package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.warcar.utils.Constants;
import com.google.common.collect.Lists;

/**
 * @author allen
 * @date 2017-12-04
 */
public class Ticket implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    public static final byte SETTLE_TYPE_CPC = 1;
    public static final byte SETTLE_TYPE_CPA = 2;
    public static final byte SETTLE_TYPE_OCPC = 3;
    public static final byte SETTLE_TYPE_CPM = 4;

    /**
     * 常规券
     */
    public static final byte TYPE_NORMAL = 1;
    /**
     * 常规备用券
     */
    public static final byte TYPE_STANDBY = 2;
    /**
     * 激励券
     */
    public static final byte TYPE_REWARD = 3;
    /**
     * 券码类
     */
    public static final byte TYPE_COUPONS = 4;
    /**
     * ADX直投广告
     */
    public static final byte TYPE_ADX_DIRECT = 5;
    /**
     * ADX互动广告
     */
    public static final byte TYPE_ADX_ACTIVITY = 6;
    /**
     * 视频券（原激励视频）
     */
    public static final byte TYPE_INSPIRE_VIDEO = 7;
    /**
     * 视频备用券（原激励视频备用券）
     */
    public static final byte TYPE_INSPIRE_VIDEO_STANDBYS = 8;
    /**
     * 三方DSP广告
     */
    public static final short TYPE_DSP = 9;
    /**
     * RTA广告
     */
    public static final short TYPE_RTA = 10;
    /**
     * 推送券
     */
    public static final short TYPE_PUSH = 11;
    /**
     * 活动券
     */
    public static final short TYPE_ACTIVITY = 12;
    /**
     * 直投券
     */
    public static final short TYPE_DIRECT = 13;


    /**
     * 开启
     */
    public static final byte STATUS_OPEN = 1;
    /**
     * 暂停
     */
    public static final byte STATUS_PAUSE = 2;
    /**
     * 停止
     */
    public static final byte STATUS_CLOSE = 3;
    /**
     * 已删除
     */
    public static final byte STATUS_DELETED = 99;

    public static final int PAUSE_REASON_NONE = 0;
    /**
     * 日预算不足
     */
    public static final int PAUSE_REASON_OUT_OF_DAILYBUDGET = 1;
    /**
     * 余额不足
     */
    public static final int PAUSE_REASON_BALANCE_NOT_ENOUGHT = 2;
    /**
     * 未到投放日期
     */
    public static final int PAUSE_REASON_NO_START = 3;
    /**
     * 已结束
     */
    public static final int PAUSE_REASON_ENDED = 4;
    /**
     * 时间段预算不足
     */
    public static final int PAUSE_REASON_OUT_OF_TIMEBUDGET = 5;
    /**
     * 其他原因
     */
    public static final int PAUSE_REASON_OTHER = 99;

    /**
     * 投放模式：快速
     */
    public static final int CONSUME_MODAL_FAST = 0;
    /**
     * 投放模式：匀速
     */
    public static final int CONSUME_MODAL_AVERAGE = 1;
    /**
     * 素材流量分配：算法优选
     */
    public static final int ASSETS_DISTRIBUTE_ALGORITHM = 0;
    /**
     * 素材流量分配：手动配置
     */
    public static final int ASSETS_DISTRIBUTE_MANUAL = 1;

    private BigInteger id;
    private String name;
    private BigInteger advertiser;
    /**
     * 结算方式：1- CPC、2- CPA、3-OCPC、4- CPM
     */
    private Byte settleType;
    private Integer price;
    private Byte type;
    private Integer budgetDaily;
    private String domainCode;
    private Double standaloneCost;
    private String url;
    private Date validStartDate;
    private Date validEndDate;
    /**
     * 是否支持微信
     * @see com.bxm.warcar.utils.Constants#YES
     * @see com.bxm.warcar.utils.Constants#NO
     */
    @Deprecated
    private Byte isSupportWechat;

    /**
     * 最后一次状态更新时间
     */
    private Date updateTime;
    /**
     * 投放支持的应用
     * @see App
     */
    private List<Integer> apps;
    /**
     * 用户评分及格分数线
     */
    private Integer userGradePassScore;
    private Byte status;
    private Integer pauseReason;
    /**
     * CPA 预期价格
     */
    private Integer cpaPrice;
    /**
     * 底价
     */
    private Integer floorPrice;
    /**
     * 支持的平台
     */
    private List<TicketOs> oss;
    /**
     * 标签
     */
    private List<Tag> tags;
    /**
     * 开关配置
     */
    private List<TicketOnoff> onoffs;
    /**
     * 素材
     */
    @Deprecated
    private List<TicketAssets> assets;
    /**
     * 价格配置
     */
    private List<TicketPrice> prices;
    /**
     * 权重干预系数
     */
    private List<TicketWeightMif> mifs;

    /**
     * 广告券获得/点击等所有触发时间
     */
    private Date time;
    /**
     * 广告券票据号，当得到这种广告券之后会创建一个票据作为后面点击等数据的统计依据。
     * bxm_id > 点击后生成的，用于有效点击的传参依据
     */
    private String billid;
    /**
     * 本次点击实际出价
     */
    private Integer offerPrice;
    /**
     * 是否是OCPC广告
     */
    private Byte ocpc;
    /**
     * 屏蔽阈值
     */
    private Integer closeThreshold;
    /**
     * 本次获取广告券所对应的素材
     */
    private TicketAssets offerAssets;

    /**
     * 广告组 ID
     */
    private Long groupId;

    /**
     * 票据，获取广告券后会创建一个票据号，用于对后面曝光和点击的核验
     */
    private String ticket;

    /**
     * 限价上线阈值，单位：厘
     */
    private Long thresholdLimitPriceOnline;
    /**
     * 限价下线阈值，单位：厘
     */
    private Long thresholdLimitPriceOffline;

    /**
     *  bxmId
     */
    private String bxmId;

    /**
     * 算法名称
     */
    private String algorithmlName;

    /**
     * 投放模式。
     */
    private Integer consumeModal;

    /**
     * 券app相关扩展信息
     */
    private TicketAppExtend adTicketAppExtend;

    /**
     * 券rta相关扩展信息
     */
    private TicketRtaExtend rtaExtend;

    /**
     * 券支持的广告位场景列表
     */
    private List<TicketPositionScene> positionScenes;

    /**
     * 素材流量分配类型,0.算法优选 1.手动配置
     */
    private Short assetsDistribute;


    private String bestAssetsId;

    /**
     * 频次扩容时间
     */
    private Date timesEnlargeDate;

    /**
     * 权益奖品ID
     */
    private BigInteger rightsId;

    /**
     * 麒麟域名组ID
     */
    private String kylinGroupId;

    /**
     * 深层目标cpa
     */
    private Integer deepCpaPrice;

    /**
     * 深层目标对应的行为类型
     */
    private Integer deepExpectActionType;

    /**
     * 素材是否用的是互动广告的那套素材
     * adsprod-counter用来做判断
     */
    public boolean isOldAssets(){
        return null != this.type &&
                (Ticket.TYPE_NORMAL == this.type ||
                        Ticket.TYPE_STANDBY == this.type ||
                        Ticket.TYPE_REWARD == this.type ||
                        Ticket.TYPE_COUPONS == this.type ||
                        Ticket.TYPE_DSP == this.type ||
                        Ticket.TYPE_RTA == this.type ||
                        Ticket.TYPE_PUSH == this.type
                );
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    /**
     * 是否为自动结算类型
     * @return
     */
    @JSONField(serialize = false, deserialize = false)
    public boolean isAutoSettleType() {
        return null != settleType && (settleType == SETTLE_TYPE_CPC || settleType == SETTLE_TYPE_CPM);
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isNormalType() {
        return null != type && type == TYPE_NORMAL;
    }

    /**
     * 该广告券的状态是否为打开(可用)
     * @return
     */
    @JSONField(serialize = false, deserialize = false)
    public boolean isAvailableForStatus() {
        return null != status && status == STATUS_OPEN;
    }

    /**
     * 该广告券是否有可用的素材
     * @return
     */
    @Deprecated
    @JSONField(serialize = false, deserialize = false)
    public boolean isAvailableForAssets() {
        if (CollectionUtils.isEmpty(assets)) {
            return false;
        }
        for (TicketAssets asset : assets) {
            if (asset.isAvailable()) {
                return true;
            }
        }
        return false;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isOcpc() {
        return ocpc != null && ocpc == Constants.YES;
    }

    @Deprecated
    public TicketAssets randomAssets() {
        // 筛选掉关闭的素材
        List<TicketAssets> rst = Lists.newArrayList();
        for (TicketAssets asset : assets) {
            if (asset.isAvailable()) {
                rst.add(asset);
            }
        }

        return rst.size() == 0 ? null : rst.get(RandomUtils.nextInt(rst.size()));
    }

    public boolean isSupportedOs(int os) {
        if (CollectionUtils.isEmpty(oss)) {
            return false;
        }
        for (TicketOs ticketOs : oss) {
            if (ticketOs.getSupportOs() == os) {
                return true;
            }
        }
        return false;
    }

    public boolean isSupportedPositionScene(Byte positionScene) {
        if (CollectionUtils.isEmpty(positionScenes)) {
            //不限
            return true;
        }
        for (TicketPositionScene scene : positionScenes) {
            if (scene.getScene().equals(positionScene)) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedWechat() {
        return null != isSupportWechat && isSupportWechat == Constants.YES;
    }

    public String getSettleTypeName() {
        if (null == settleType) {
            return "UNKNOWN";
        }
        return settleType == SETTLE_TYPE_CPC ? "CPC" :
                settleType == SETTLE_TYPE_CPA ? "CPA" :
                settleType == SETTLE_TYPE_CPM ? "CPM" :
                        "UNKNOWN";
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigInteger getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(BigInteger advertiser) {
        this.advertiser = advertiser;
    }

    public Byte getSettleType() {
        return settleType;
    }

    public void setSettleType(Byte settleType) {
        this.settleType = settleType;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Integer getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Integer budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Byte getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Byte isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public List<TicketOnoff> getOnoffs() {
        return onoffs;
    }

    public void setOnoffs(List<TicketOnoff> onoffs) {
        this.onoffs = onoffs;
    }

    public List<TicketOs> getOss() {
        return oss;
    }

    public void setOss(List<TicketOs> oss) {
        this.oss = oss;
    }

    @Deprecated
    public List<TicketAssets> getAssets() {
        return assets;
    }

    @Deprecated
    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public List<TicketPrice> getPrices() {
        return prices;
    }

    public void setPrices(List<TicketPrice> prices) {
        this.prices = prices;
    }

    public List<TicketWeightMif> getMifs() {
        return mifs;
    }

    public void setMifs(List<TicketWeightMif> mifs) {
        this.mifs = mifs;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getBillid() {
        return billid;
    }

    public void setBillid(String billid) {
        this.billid = billid;
    }

    public Integer getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Integer cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Integer getFloorPrice() {
        return floorPrice;
    }

    public void setFloorPrice(Integer floorPrice) {
        this.floorPrice = floorPrice;
    }

    public Integer getOfferPrice() {
        return offerPrice;
    }

    public void setOfferPrice(Integer offerPrice) {
        this.offerPrice = offerPrice;
    }

    public Byte getOcpc() {
        return ocpc;
    }

    public void setOcpc(Byte ocpc) {
        this.ocpc = ocpc;
    }

    public Integer getCloseThreshold() {
        return closeThreshold;
    }

    public void setCloseThreshold(Integer closeThreshold) {
        this.closeThreshold = closeThreshold;
    }

    public TicketAssets getOfferAssets() {
        return offerAssets;
    }

    public void setOfferAssets(TicketAssets offerAssets) {
        this.offerAssets = offerAssets;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public List<Integer> getApps() {
        return apps;
    }

    public void setApps(List<Integer> apps) {
        this.apps = apps;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Long getThresholdLimitPriceOnline() {
        return thresholdLimitPriceOnline;
    }

    public void setThresholdLimitPriceOnline(Long thresholdLimitPriceOnline) {
        this.thresholdLimitPriceOnline = thresholdLimitPriceOnline;
    }

    public Long getThresholdLimitPriceOffline() {
        return thresholdLimitPriceOffline;
    }

    public void setThresholdLimitPriceOffline(Long thresholdLimitPriceOffline) {
        this.thresholdLimitPriceOffline = thresholdLimitPriceOffline;
    }

    public String getBestAssetsId() {
        return bestAssetsId;
    }

    public void setBestAssetsId(String bestAssetsId) {
        this.bestAssetsId = bestAssetsId;
    }

    public String getBxmId() {
        return bxmId;
    }

    public void setBxmId(String bxmId) {
        this.bxmId = bxmId;
    }

    public String getAlgorithmlName() {
        return algorithmlName;
    }

    public void setAlgorithmlName(String algorithmlName) {
        this.algorithmlName = algorithmlName;
    }

    public Integer getConsumeModal() {
        return consumeModal;
    }

    public void setConsumeModal(Integer consumeModal) {
        this.consumeModal = consumeModal;
    }

    public TicketAppExtend getAdTicketAppExtend() {
        return adTicketAppExtend;
    }

    public void setAdTicketAppExtend(TicketAppExtend adTicketAppExtend) {
        this.adTicketAppExtend = adTicketAppExtend;
    }

    public TicketRtaExtend getRtaExtend() {
        return rtaExtend;
    }

    public void setRtaExtend(TicketRtaExtend rtaExtend) {
        this.rtaExtend = rtaExtend;
    }

    public List<TicketPositionScene> getPositionScenes() {
        return positionScenes;
    }

    public void setPositionScenes(List<TicketPositionScene> positionScenes) {
        this.positionScenes = positionScenes;
    }

    public Short getAssetsDistribute() {
        return assetsDistribute;
    }

    public void setAssetsDistribute(Short assetsDistribute) {
        this.assetsDistribute = assetsDistribute;
    }

    public Date getTimesEnlargeDate() {
        return timesEnlargeDate;
    }

    public void setTimesEnlargeDate(Date timesEnlargeDate) {
        this.timesEnlargeDate = timesEnlargeDate;
    }

    public BigInteger getRightsId() {
        return rightsId;
    }

    public void setRightsId(BigInteger rightsId) {
        this.rightsId = rightsId;
    }

    public boolean isEnableKylinDynamicUpdate() {
        return StringUtils.isNotBlank(kylinGroupId);
    }

    public String getKylinGroupId() {
        return kylinGroupId;
    }

    public void setKylinGroupId(String kylinGroupId) {
        this.kylinGroupId = kylinGroupId;
    }

    public Integer getDeepCpaPrice() {
        return deepCpaPrice;
    }

    public void setDeepCpaPrice(Integer deepCpaPrice) {
        this.deepCpaPrice = deepCpaPrice;
    }

    public Integer getDeepExpectActionType() {
        return deepExpectActionType;
    }

    public void setDeepExpectActionType(Integer deepExpectActionType) {
        this.deepExpectActionType = deepExpectActionType;
    }
}
