package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

/**
 * @author allen
 * @since 1.0.0
 */
public class ViewRequest extends CounterRequest implements Serializable {

    private static final long serialVersionUID = -9056224658004481434L;

    private String uid;
    @ValidateNotNull
    private BigInteger ticketId;
    @ValidateNotNull
    private String position;
    private BigInteger assetsId;
    /**
     * 入口广告id
     */
    private BigInteger entrTicketId;
    /**
     * 入口素材id
     */
    private BigInteger entrAssetsId;
    /**
     * Bid id
     */
    private String bidid;
    /**
     * Outer bid id
     */
    private String obidid;
    /**
     * Adx app id
     */
    private String adxAppId;

    public ViewRequest() {
    }

    public ViewRequest(String uid, BigInteger ticketId, String position) {
        this(uid, ticketId, position, null);
    }

    public ViewRequest(String uid, BigInteger ticketId, String position, BigInteger assetsId) {
        this.uid = uid;
        this.ticketId = ticketId;
        this.position = position;
        this.assetsId = assetsId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public BigInteger getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(BigInteger assetsId) {
        this.assetsId = assetsId;
    }

    public BigInteger getEntrTicketId() {
        return entrTicketId;
    }

    public void setEntrTicketId(BigInteger entrTicketId) {
        this.entrTicketId = entrTicketId;
    }

    public BigInteger getEntrAssetsId() {
        return entrAssetsId;
    }

    public void setEntrAssetsId(BigInteger entrAssetsId) {
        this.entrAssetsId = entrAssetsId;
    }

    public String getBidid() {
        return bidid;
    }

    public void setBidid(String bidid) {
        this.bidid = bidid;
    }

    public String getObidid() {
        return obidid;
    }

    public void setObidid(String obidid) {
        this.obidid = obidid;
    }

    public String getAdxAppId() {
        return adxAppId;
    }

    public void setAdxAppId(String adxAppId) {
        this.adxAppId = adxAppId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
