package com.bxm.adsprod.facade.ticket.simulation;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import com.bxm.adsprod.facade.ticket.TicketInspireRequest;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 模拟广告服务，仅仅用于模拟请求来获取广告结果。
 *
 * @author allen
 * @since 1.0.0
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface TicketSimulationService {

    /**
     * 模拟获取广告
     *
     * @param ticketRequest 请求对象
     * @return 召回广告，按照权重排序
     */
    @RequestMapping(value = "/ticketSimulationService/simulate", method = RequestMethod.POST)
    SimulationResult simulate(@RequestBody TicketRequest ticketRequest);

    /**
     * 模拟获取激励视频广告
     *
     * @param request 请求对象
     * @return 召回广告，按照权重排序
     */
    @RequestMapping(value = "/ticketSimulationService/simulateInspire", method = RequestMethod.POST)
    SimulationResult simulateInspire(@RequestBody TicketInspireRequest request);
}
