/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public final class TicketKeyGenerator {
    public static KeyGenerator getUser(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", parameters.get("imei")});
    }

    public static KeyGenerator getTimes(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMES", parameters.get("ticketid")});
    }

    public static KeyGenerator getTicketAssets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ASSETS"});
    }

    public static KeyGenerator getCouponsInfo(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COUPONSINFO", parameters.get("ticketid")});
    }

    public static KeyGenerator getTicketAssetsCoupons() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ASSETS", "COUPONS"});
    }

    public static KeyGenerator getTicketAdx(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ADX", parameters.get("ticketid")});
    }

    public static KeyGenerator getTicketAssetsAdx() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ASSETS", "ADX"});
    }

    public static KeyGenerator getTicketInspireVideo(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "INSPIREVIDEO", parameters.get("ticketid")});
    }

    public static KeyGenerator getTicketAssetsInspireVideo() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ASSETS", "INSPIREVIDEO"});
    }

    public static KeyGenerator getTicketLandPlan() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "LAND", "PLAN"});
    }

    public static KeyGenerator getAvailableTickets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "AVAILABLE"});
    }

    public static KeyGenerator getAllTickets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ALL"});
    }

    public static KeyGenerator getTicketPrice(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketPriceOfTodayFirst(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_TF", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketPriceFloatPercent(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_FP", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketMif(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_MIF", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketProfitForCpa(LocalDate date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PROFIT_FOR_CPA", date.format(DateTimeFormatter.ofPattern("yyyyMMdd"))});
    }

    public static KeyGenerator getDirectPositionTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "POSITION", "TICKET"});
    }

    public static KeyGenerator getDirectPositionMaterial() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "POSITION", "MATERIAL"});
    }

    public static KeyGenerator getDirectPositionMaterialCTR(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "POSITION", "MATERIAL", "CTR", positionId});
    }

    public static KeyGenerator getDirectTicketMaterial() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "POSITION", "TICKET", "MATERIAL"});
    }

    public static KeyGenerator getDirectTicketIDPosition() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "TICKET", "ID", "POSITION"});
    }

    public static KeyGenerator getDirectMaterialView(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "TICKET", "MATERIAL", "VIEW", positionId});
    }

    public static KeyGenerator getDirectMaterialClick(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "TICKET", "MATERIAL", "CLICK", positionId});
    }

    public static KeyGenerator landingResetPosition() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "LANDING", "RESET", "POSITIONS"});
    }

    public static KeyGenerator landingResetTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "LANDING", "RESET", "TICKETS"});
    }

    public static KeyGenerator getValidClickUser(String keyword) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "VALIDCLICK", "UID_IP", keyword});
    }

    public static KeyGenerator ticketPositionTimesLimitConfigClose(BigInteger ticketId, String configId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "POSITION", "TIMESLIMIT", "CONFIG", LocalDateTimeHelper.getDateStringNow(), ticketId, configId});
    }

    public static KeyGenerator ticketPositionTimesLimitConfigCount(BigInteger ticketId, String configId, String position) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "POSITION", "TIMESLIMIT", "CONFIG", LocalDateTimeHelper.getDateStringNow(), ticketId, configId, position});
    }

    public static KeyGenerator getPddTickets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "PDD", "TICKETS"});
    }

    public static KeyGenerator getPositionCodeKey() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "CODE"});
    }

    public static KeyGenerator getKeyGeneratorByPositionDomainiCode() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "DOMAINCODE"});
    }

    public static KeyGenerator getAttributeTag() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ATTRIBUTE", "TAG"});
    }

    public static KeyGenerator positionTicketWeight(String position) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "POSITION_TICKET", position});
    }

    public static KeyGenerator positionTicketWeightNew(String position) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "POSITION_TICKET", "NEW", position});
    }

    public static KeyGenerator ticketWeight() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "GLOBAL_TICKET"});
    }

    @Deprecated
    public static KeyGenerator newVideoTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "VIDEO", "NEW", "TICKET"});
    }

    public static KeyGenerator newTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "NEW", "TICKET"});
    }

    public static KeyGenerator CPCGoOCPCTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CPC", "OCPC", "CONFIG", "TICKET"});
    }

    public static KeyGenerator OCPCConfigTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CONFIG", "TICKET"});
    }

    public static KeyGenerator arpuConfigTicket() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "CONFIG", "NEW", "TICKET"});
    }

    public static KeyGenerator getPacing(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "PACING", positionId});
    }

    public static KeyGenerator getPayTicketCpa(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CPA", "POSITION", positionId});
    }

    public static KeyGenerator getOCPC1(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "OCPC1", positionId});
    }

    public static KeyGenerator newAssets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "NEW", "ASSETS"});
    }

    public static KeyGenerator assetsConfig() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ASSETS", "RADOM", "CONFIG"});
    }

    public static KeyGenerator getTicketRights() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RIGHTS"});
    }

    public static KeyGenerator getDownloadLandingPage() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "DOWNLOADLANDINGPAGE"});
    }

    public static KeyGenerator getActivityTicketBlack(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "POSITION", "FILTER", "TICKET", positionId});
    }

    public static class CashAward {
        public static KeyGenerator getDailyUserCashAmount(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "AWARD", "CASH", date});
        }
    }

    public static class Popup {
        public static KeyGenerator getInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POPUP", "INFO"});
        }
    }

    public static class OssFile {
        public static KeyGenerator youdaoEndUrl() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "oss", "file", "youdao"});
        }
    }

    public static class TIMENODE {
        public static KeyGenerator currentTimeNodeClick(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "CURRENTTIME", "CLICK", date});
        }

        public static KeyGenerator currentTimeNodeConsume(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "CURRENTTIME", "CONSUME", date});
        }
    }

    public static class API {
        public static KeyGenerator getAllAssetIds() {
            return () -> KeyBuilder.build((Object[])new Object[]{"API", "THIRD", "ASSETSID"});
        }

        public static KeyGenerator getRequestFail() {
            return () -> KeyBuilder.build((Object[])new Object[]{"API", "DOT", "REQUEST", "FAIL"});
        }

        public static KeyGenerator getRequestInfo(String req_id) {
            return () -> KeyBuilder.build((Object[])new Object[]{"API", "DOT", "REQUEST", req_id});
        }

        public static KeyGenerator getOuterDspWeight() {
            return () -> KeyBuilder.build((Object[])new Object[]{"API", "SSP", "POSITION"});
        }

        public static KeyGenerator getOuterDspInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"API", "SSP", "DSP"});
        }

        public static KeyGenerator taobaoClick(String bxmId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"API", "TAOBAO", "CLICK", bxmId});
        }

        public static KeyGenerator ydPositionIdAndBxmTickassetsIdetId() {
            return () -> KeyBuilder.build((Object[])new Object[]{"YD", "AND", "BXM", "TICKETID"});
        }
    }

    public static class Activity {
        public static KeyGenerator getActBasicMsg(Long activityId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "BASIC", "MSG", activityId});
        }
    }

    public static class Tags {
        public static KeyGenerator getTags() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "TAGS"});
        }
    }

    public static class TicketFm {
        public static KeyGenerator getSeqLatelyUser(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SEQ", "LATELY", "USER", uid});
        }

        public static KeyGenerator getSeqCount(Date date, long id) {
            return () -> KeyBuilder.build((Object[])new Object[]{DateHelper.convertDateToString((Date)date, (String)"yyyyMMdd"), id});
        }

        public static KeyGenerator getSeqCountNotTicketId(Date date) {
            return () -> KeyBuilder.build((Object[])new Object[]{DateHelper.convertDateToString((Date)date, (String)"yyyyMMdd")});
        }

        public static KeyGenerator getSeqCount(String dateStr, long id) {
            return () -> KeyBuilder.build((Object[])new Object[]{dateStr, id});
        }

        public static KeyGenerator getSpm() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SPM", "USERS", DateHelper.getDate()});
        }

        public static KeyGenerator getCurrentUser(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SEQ", "REPEAT", "DATE", DateHelper.getDate(), "USER", uid});
        }

        public static KeyGenerator getCurrentActivity(long activityId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SEQ", "ACTIVITY", activityId, "BYSPM"});
        }

        public static KeyGenerator getTicketCountCurrentDay() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SEQ"});
        }

        public static KeyGenerator getTicketCountRepeat(long ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "REPEAT", "ACTIVITY", ticketId});
        }

        public static KeyGenerator getActivityCount(long activityId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SEQ", "ACTIVITY", activityId});
        }

        public static KeyGenerator getPrevTicketInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "USERS", "DATE", DateHelper.getDate()});
        }

        public static KeyGenerator getLaterUser(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "LATELY", "USER", uid});
        }

        public static KeyGenerator getPrevShowDate() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "LATELY"});
        }

        public static KeyGenerator getPrevActivityShowDate(long activityId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "LATELY", "ACTIVITY", activityId});
        }

        public static KeyGenerator getPrevCost() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "COST", "LATELY"});
        }

        public static KeyGenerator getPrevCost(long activityId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "COST", "LATELY", "ACTIVITY", activityId});
        }

        public static KeyGenerator getUserEveryTicketCount(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "UDAILY_VIEW", DateHelper.getDate(), uid});
        }

        public static KeyGenerator getFmLogByBxmId(String bxmId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "TICKET", "FM", bxmId});
        }

        public static KeyGenerator getFmLogFinalTicketId() {
            return () -> KeyBuilder.build((Object[])new Object[]{"BEST", "TICKET"});
        }

        public static KeyGenerator getFmLogTicketList() {
            return () -> KeyBuilder.build((Object[])new Object[]{"SORTLIST"});
        }

        public static KeyGenerator getUserBehaviorTrace(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", "BEHAVIOR", "TRACE", uid});
        }

        public static KeyGenerator getCVRUserBehaviorTrace(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", "BEHAVIOR", "TRACE", "CVR", uid});
        }

        public static KeyGenerator getCVR0UserBehaviorTrace(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", "BEHAVIOR", "TRACE", "CVR0", uid});
        }

        public static KeyGenerator getAppList(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", "APPLIST", uid});
        }

        public static KeyGenerator getPrevAssetIdCost(long assetId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "COST", "LATELY", "ASSETID", assetId});
        }

        public static KeyGenerator getRecordAssetId() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "LATELY", "ASSETID"});
        }

        public static KeyGenerator getSeqAssetIdViewCount(long assetId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "SEQ", "ASSETID", assetId});
        }

        public static KeyGenerator getSeqAssetIdCount(Date date, long assetId) {
            return () -> KeyBuilder.build((Object[])new Object[]{DateHelper.convertDateToString((Date)date, (String)"yyyyMMdd"), "ASSETID", assetId});
        }
    }

    public static class CrowdPack {
        public static KeyGenerator getThirdCrowdPack() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CROWD_PACK", "THIRD"});
        }

        public static KeyGenerator getTicketCrowdPack() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CROWD_PACK", "THIRD", "TICKET"});
        }
    }

    public static class Position {
        @Deprecated
        public static KeyGenerator getClosed(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CLOSED_TICKET", "POSITION", DateHelper.getDate(), positionId});
        }

        public static KeyGenerator getClosedTicket(String groupId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CLOSED_TICKET", "GROUP", DateHelper.getDate(), groupId});
        }
    }

    public static class Adx {
        public static KeyGenerator getPositionListForDC() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "MATERIAL", "2H"});
        }

        public static KeyGenerator getCreativeCtrForDC(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "MATERIAL", "2H", positionId});
        }

        public static KeyGenerator getPositionNormal() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ADX", "POSITION", "CREATIVE", "NORMAL"});
        }

        public static KeyGenerator getTicketPack() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ADX", "TICKET_PACK"});
        }

        public static KeyGenerator getGeTuiToken() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ADX", "GETUI", "CLIP", "TOKEN"});
        }
    }

    public static class Coupon {
        public static KeyGenerator getCouponInfo(BigInteger ticket_id, Short type) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", ticket_id, "COUPONS", "TYPE", type});
        }
    }

    public static class DIYSite {
        public static KeyGenerator getPageInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "SITE", "DIY", "PAGE"});
        }
    }

    public static class Threshold {
        private Threshold() {
        }

        public static KeyGenerator getLimitPriceConfig() {
            return () -> "AD:TICKET:THRESHOLD:LIMITPRICE_CONFIG";
        }

        public static KeyGenerator getLimitPriceEnabled() {
            return () -> "AD:TICKET:THRESHOLD:LIMITPRICE_ENABLED:" + DateHelper.getDate();
        }

        public static KeyGenerator getLimitPriceRemainder() {
            return () -> "AD:TICKET:THRESHOLD:LIMITPRICE_REMAINDER:" + DateHelper.getDate();
        }
    }

    public static class Ticket {
        public static final String F_SOURCE = "source";
        public static final String F_SHOW = "show";
        public static final String F_CLICK = "click";

        private Ticket() {
        }

        public static KeyGenerator getTicket(String ticket) {
            return () -> KeyBuilder.build((Object[])new Object[]{"TICKET", ticket});
        }
    }

    public static class Kylin {
        private Kylin() {
        }

        public static KeyGenerator hashDomains(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "KYLIN", "DOMAIN", String.valueOf(ticketId)});
        }

        public static KeyGenerator hashAvailableUrl() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "KYLIN", "URL"});
        }

        public static KeyGenerator hashCheckPlan() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "KYLIN", "CHECKPLAN"});
        }
    }

    public static class Temp {
        private Temp() {
        }

        public static KeyGenerator getTimelineOutOfBudget(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TEMP", "TIMELINE", "OUT_OF_BUDGET", ticketId});
        }

        public static KeyGenerator getTickets(int os, int app, String regionCode, String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TEMP", "TICKET", os, app, regionCode, position});
        }
    }

    public static class Ocpc {
        public static KeyGenerator getConsume(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CONSUME", ticketId});
        }

        public static KeyGenerator getClick(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CLICK", ticketId});
        }

        @Deprecated
        public static KeyGenerator getValidClick(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "VALIDCLICK", ticketId});
        }

        public static KeyGenerator getValidClick(BigInteger ticketId, String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "VALIDCLICK", ticketId, position});
        }

        public static KeyGenerator getClosed(String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CLOSED", position});
        }

        public static KeyGenerator getFloor() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "FLOOR"});
        }

        public static KeyGenerator getOfferSheetLock(String position, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "OFFER_SHEET_LOCK", position, ticketId});
        }

        public static KeyGenerator getOfferSheet(String position, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "OFFER_SHEET", position, ticketId});
        }

        public static KeyGenerator officPriceByBxmId(String bxmId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CVR", "PRICE", bxmId});
        }
    }

    public static class Scene {
        private Scene() {
        }

        public static KeyGenerator getScene(int scene) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "SCENE", scene});
        }

        public static KeyGenerator getSceneViews(int scene, String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "SCENE", scene, uid});
        }
    }

    public static class Weight {
        @Deprecated
        public static KeyGenerator getWeight(BigInteger ticketId, String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", ticketId});
        }

        public static KeyGenerator getWeight(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", positionId});
        }
    }

    public static class Statistics {
        private Statistics() {
        }

        public static KeyGenerator getRequestOfDaily(String ticketId) {
            return Statistics.getRequestOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getRequestOfDaily(String date, String ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_REQUEST", date, ticketId});
        }

        public static KeyGenerator getRequestOfDailyV2() {
            return Statistics.getRequestOfDailyV2(DateHelper.getDate());
        }

        public static KeyGenerator getRequestOfDailyV2(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_REQUEST_V2", date});
        }

        public static KeyGenerator getBudgetOfDaily() {
            return Statistics.getBudgetOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getBudgetOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", date});
        }

        public static KeyGenerator getAdxBudgetOfDaily() {
            return Statistics.getAdxBudgetOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getAdxBudgetOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", "ADX", date});
        }

        public static KeyGenerator getPanGuBudgetOfDaily() {
            return Statistics.getPanGuBudgetOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getPanGuBudgetOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", "PANGU", date});
        }

        public static KeyGenerator getPanGuCostOfDaily() {
            return Statistics.getPanGuCostOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getPanGuCostOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_CONST", "PANGU", date});
        }

        public static KeyGenerator getClickOfDaily() {
            return Statistics.getClickOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getClickOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "CLICK", date});
        }

        public static KeyGenerator getValidClickOfDaily(BigInteger ticketId) {
            return Statistics.getValidClickOfDaily(DateHelper.format((String)"yyyyMMdd"), ticketId);
        }

        public static KeyGenerator getValidClickOfDaily(String date, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VALID_CLICK", date, ticketId});
        }

        public static KeyGenerator getPanGuValidClickOfDaily(BigInteger ticketId) {
            return Statistics.getPanGuValidClickOfDaily(DateHelper.format((String)"yyyyMMdd"), ticketId);
        }

        public static KeyGenerator getPanGuValidClickOfDaily(String date, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VALID_CLICK", "PANGU", date, ticketId});
        }

        public static KeyGenerator getViewOfDaily() {
            return Statistics.getViewOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getViewOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VIEW", date});
        }

        public static KeyGenerator getPositionViewOfDaily(String position) {
            return Statistics.getPositionViewOfDaily(DateHelper.format((String)"yyyyMMdd"), position);
        }

        public static KeyGenerator getPositionViewOfDaily(String date, String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VIEW", date, position});
        }

        public static KeyGenerator getBudgetOfHourly() {
            return Statistics.getBudgetOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getBudgetOfHourly(int hour) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_BUDGET", DateHelper.format((String)"yyyyMMdd"), hour});
        }

        public static KeyGenerator getViewOfHourly() {
            return Statistics.getViewOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getViewOfHourly(int hour) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_VIEW", DateHelper.format((String)"yyyyMMdd"), hour});
        }

        public static KeyGenerator getClickOfDaily(BigInteger ticketId) {
            return Statistics.getClickOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getClickOfDaily(String date, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_CLICK", date, ticketId});
        }

        public static KeyGenerator getViewOfDaily(BigInteger ticketId) {
            return Statistics.getViewOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getViewOfDaily(String date, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_VIEW", date, ticketId});
        }

        public static KeyGenerator getClickOfWeekly(BigInteger ticketId) {
            return Statistics.getClickOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getClickOfWeekly(String dateweek, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_CLICK", dateweek, ticketId});
        }

        public static KeyGenerator getViewOfWeekly(BigInteger ticketId) {
            return Statistics.getViewOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getViewOfWeekly(String dateweek, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_VIEW", dateweek, ticketId});
        }

        public static KeyGenerator getBudgetOfPositionGroup(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET_P_G", DateHelper.format((String)"yyyyMMdd"), ticketId});
        }

        public static KeyGenerator getTicketGroupDailyClickKey(Long groupId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_CLICK_T_G", DateHelper.format((String)"yyyyMMdd"), groupId});
        }

        public static KeyGenerator getTicketGroupDailyViewKey(Long groupId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_VIEW_T_G", DateHelper.format((String)"yyyyMMdd"), groupId});
        }

        public static KeyGenerator getTicketGroupWeekClickKey(Long groupId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_CLICK_T_G", DateHelper.format((String)"yyyyw"), groupId});
        }

        public static KeyGenerator getTicketGroupWeekViewKey(Long groupId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_VIEW_T_G", DateHelper.format((String)"yyyyw"), groupId});
        }

        public static KeyGenerator getTicketAssets2Hour(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "2H", positionId});
        }

        public static KeyGenerator getTicketAssets24Hour(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "24H", positionId});
        }

        public static KeyGenerator getTicketAllAssetsClick(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "ALL", "CLICKS", positionId});
        }

        public static KeyGenerator getTicketAllAssetsView(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "ALL", "VIEWS", positionId});
        }

        @Deprecated
        public static KeyGenerator getTicketAllAssetsValidClick(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "ALL", "VALIDCLICKS", positionId});
        }

        @Deprecated
        public static KeyGenerator getTicketAllAssetsValidClick(String positionId, String assetsId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "ALL", "VALIDCLICKS", positionId, assetsId});
        }

        @Deprecated
        public static KeyGenerator getTicketDailyAssetsView() {
            return Statistics.getTicketDailyAssetsView(DateHelper.getDate());
        }

        @Deprecated
        public static KeyGenerator getTicketDailyAssetsView(String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "VIEWS", daily});
        }

        @Deprecated
        public static KeyGenerator getTicketDailyAssetsClick() {
            return Statistics.getTicketDailyAssetsClick(DateHelper.getDate());
        }

        @Deprecated
        public static KeyGenerator getTicketDailyAssetsClick(String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "CLICKS", daily});
        }

        @Deprecated
        public static KeyGenerator getTicketDailyAssetsValidClick(String assetsId) {
            return Statistics.getTicketDailyAssetsValidClick(assetsId, DateHelper.getDate());
        }

        @Deprecated
        public static KeyGenerator getTicketDailyAssetsValidClick(String assetsId, String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "VALIDCLICKS", assetsId, daily});
        }

        public static KeyGenerator getTicketAllCreativeValidClick(String positionId, String ticketId, String assetsId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "ALL", "VALIDCLICKS", positionId, ticketId, assetsId});
        }

        public static KeyGenerator getTicketDailyCreativeView(String ticketId) {
            return Statistics.getTicketDailyCreativeView(ticketId, DateHelper.getDate());
        }

        public static KeyGenerator getTicketDailyCreativeView(String ticketId, String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "VIEWS", ticketId, daily});
        }

        public static KeyGenerator getTicketDailyCreativeClick(String ticketId) {
            return Statistics.getTicketDailyCreativeClick(ticketId, DateHelper.getDate());
        }

        public static KeyGenerator getTicketDailyCreativeClick(String ticketId, String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "CLICKS", ticketId, daily});
        }

        public static KeyGenerator getTicketDailyCreativeValidClick(String ticketId, String assetsId) {
            return Statistics.getTicketDailyCreativeValidClick(ticketId, assetsId, DateHelper.getDate());
        }

        public static KeyGenerator getTicketDailyCreativeValidClick(String ticketId, String assetsId, String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "VALIDCLICKS", ticketId, assetsId, daily});
        }

        public static KeyGenerator getPanGuTicketDailyCreativeValidClick(String ticketId, String assetsId) {
            return Statistics.getPanGuTicketDailyCreativeValidClick(ticketId, assetsId, DateHelper.getDate());
        }

        public static KeyGenerator getPanGuTicketDailyCreativeValidClick(String ticketId, String assetsId, String daily) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ASSETS", "DAILY", "VALIDCLICKS", "PANGU", ticketId, assetsId, daily});
        }

        public static KeyGenerator getPositionIdTestViews(String positionid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "POSITIONID_TEST", "VIEWS", positionid});
        }

        public static KeyGenerator getPositionIdTestClick(String positionid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "POSITIONID_TEST", "CLICK", positionid});
        }

        public static KeyGenerator getAdxSectionClick(String hour, String section) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ADX_SECTION", "CLICK", hour, section});
        }

        public static KeyGenerator getAdxSectionShow(String hour, String section) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ADX_SECTION", "SHOW", hour, section});
        }
    }

    public static class User {
        private User() {
        }

        public static KeyGenerator getRequestClosedTicketByUidV2(String uid) {
            return User.getRequestClosedTicketByUidV2(DateHelper.getDate(), uid);
        }

        public static KeyGenerator getRequestClosedTicketByUidV2(String date, String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER_CLOSED_TICKET_V2", "REQUEST", date, uid});
        }

        public static KeyGenerator getUserDailyViewTicketCounter(String uid, String date, String ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", "DAILY", "VIEW", "TICKET", uid, date, ticketId});
        }

        public static KeyGenerator getUserDailyClickTicketCounter(String uid, String date, String ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", "DAILY", "CLICK", "TICKET", uid, date, ticketId});
        }

        public static KeyGenerator getUser(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "LAST", uid});
        }

        public static KeyGenerator getValidClickForTag(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "VALIDCLICK", "TAG", uid});
        }

        public static KeyGenerator getValidClickForTagOfLast(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "VALIDCLICK", "TAG_LAST", uid});
        }

        public static KeyGenerator getClosedTickets(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CLOSED_TICKETS", "UID", DateHelper.getDate(), uid});
        }

        public static KeyGenerator getClosedGroup(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CLOSED_TGROUP", "UID", DateHelper.getDate(), uid});
        }

        public static KeyGenerator getClosedTicket() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "CLOSED_TICKET_ADX", DateHelper.getDate()});
        }

        @Deprecated
        public static KeyGenerator getClosedTicketByUid(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER_CLOSED_TICKET", DateHelper.getDate(), uid});
        }

        public static KeyGenerator getClickClosedTicketByUidV2(String uid) {
            return User.getClickClosedTicketByUidV2(DateHelper.getDate(), uid);
        }

        public static KeyGenerator getClickClosedTicketByUidV2(String date, String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER_CLOSED_TICKET_V2", "CLICK", date, uid});
        }

        public static KeyGenerator getViewClosedTicketByUidV2(String uid) {
            return User.getViewClosedTicketByUidV2(DateHelper.getDate(), uid);
        }

        public static KeyGenerator getViewClosedTicketByUidV2(String date, String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER_CLOSED_TICKET_V2", "VIEW", date, uid});
        }
    }

    public static class Media {
        private Media() {
        }

        public static KeyGenerator getPositions() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "ALL"});
        }

        public static KeyGenerator getAdxPositionIds() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "ADX", "ID"});
        }

        public static KeyGenerator getPositionDomain(Map<String, Object> parameters) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_DOMAIN", parameters.get("positionid"), parameters.get("domaincode")});
        }

        public static KeyGenerator getPositionTag(Map<String, Object> parameters) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_TAG", parameters.get("positionid"), parameters.get("tagcode")});
        }

        public static KeyGenerator getMediaTag(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_TAG", positionId});
        }

        @Deprecated
        public static KeyGenerator getMediaTagHighestPositions() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_TAG_HIGHEST_POSITIONS"});
        }

        public static KeyGenerator getMediaTagHighestControllers() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_TAG_HIGHEST_CONTROLLERS"});
        }

        public static KeyGenerator getPositionTest(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION_TEST", positionId});
        }

        public static KeyGenerator getPositionWhiteTicketId(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "WHITE", "TICKETID", positionId});
        }

        public static KeyGenerator getUserInfo(String appKey) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER_MEDIA", "APPKEY", appKey});
        }

        public static KeyGenerator getInspireAppKeys() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "INSPIRE", "APPKEY"});
        }

        public static KeyGenerator getAppSecret() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "MEDIA", "APPKEY"});
        }
    }

    public static class Advertiser {
        private Advertiser() {
        }

        public static KeyGenerator getBalance() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ADVERTISER", "BALANCE"});
        }

        public static KeyGenerator getStationUserWeight() {
            return () -> KeyBuilder.build((Object[])new Object[]{"STATION", "USER", "WEIGHT"});
        }

        public static KeyGenerator getConsumeForStationUserWeight() {
            return () -> KeyBuilder.build((Object[])new Object[]{"STATION", "USER", "WEIGHT", "CONSUME"});
        }

        public static KeyGenerator getAdvertiserShop(BigInteger advertiserId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"advertiser", "adshop", advertiserId});
        }
    }

    public static class Filter {
        private Filter() {
        }

        public static KeyGenerator getRegionDefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", "DEFINED"});
        }

        public static KeyGenerator getRegionUndefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", "UNDEFINED"});
        }

        public static KeyGenerator getPositionGroup(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_GROUP", ticketId});
        }

        public static KeyGenerator getPositionDefinedBlackList() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "BLACKLIST2"});
        }

        public static KeyGenerator getPositionDefinedWhiteList() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "WHITELIST2"});
        }

        public static KeyGenerator getPositionDefinedBlackConf() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "BLACKCONF2"});
        }

        public static KeyGenerator getPositionDefinedWhiteConf() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "WHITECONF2"});
        }

        public static KeyGenerator getPositionUndefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "UNDEFINED"});
        }

        public static KeyGenerator getTimeline(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMELINE", ticketId});
        }

        public static KeyGenerator getTicketGroup(BigInteger groupid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_GROUP", groupid});
        }

        public static KeyGenerator getIpLibraryDefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "IP_DEFINED"});
        }

        public static KeyGenerator getIpLibrary() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "IP_LIB"});
        }

        public static KeyGenerator getAppPackage(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "APP_PACKAGE", ticketId});
        }

        public static KeyGenerator getTicketCrowd(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_CROWD", ticketId});
        }

        public static KeyGenerator getTicketIsp(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_ISP", ticketId});
        }

        public static KeyGenerator getTicketNetworkType(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_NETWORK_TYPE", ticketId});
        }

        public static KeyGenerator getTicketAdQuality(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_AD_QUALITY", ticketId});
        }

        public static KeyGenerator getTicketNewAndOldUsers(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_NEW_AND_OLD_USERS", ticketId});
        }

        public static KeyGenerator getTicketGetuiSexUsers(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_GETUI_SEX", ticketId});
        }

        public static KeyGenerator getAdxAppEntrance(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TICKET_ADX_ENTRANCE", ticketId});
        }
    }

    public static class Lock {
        public static KeyGenerator getSubTable(String tableName) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "LOCK", tableName});
        }
    }
}

