package com.bxm.adsprod.facade.award;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 用户抽奖记录查询dto
 *
 * @ClassName UserAwardDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/26 17:52
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/26 17:52
 **/
public class UserAwardDto implements Serializable{
    private static final long serialVersionUID = -6183822127489041058L;
    /**
     * 用户ID
     */
    private String uid;

    /**
     * 活动ID
     */
    private Integer activityid;

    /**
     * 开发者
     */
    @DefaultValue("mistake_appKey")
    @ValidateLength(min = 32, max = 32)
    private String appkey;

    /**
     * 渠道
     */
    @DefaultValue("mistake_biz")
    @ValidateNotNull
    private String business;

    public String getPositionId(){
        return StringUtils.join(new Object[]{appkey, business.replaceAll("ad-|money-", "")}, "-");
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Integer getActivityid() {
        return activityid;
    }

    public void setActivityid(Integer activityid) {
        this.activityid = activityid;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    @Override
    public String toString() {
        return "UserAwardDto{" +
                "uid='" + uid + '\'' +
                ", activityid=" + activityid +
                ", appkey='" + appkey + '\'' +
                ", business='" + business + '\'' +
                '}';
    }
}
