package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import com.bxm.adsprod.facade.award.AwardDto;
import com.bxm.adsprod.facade.ssp.DirectTicketSsp;
import com.bxm.adsprod.facade.ssp.TicketInspireSsp;
import com.bxm.adsprod.facade.ssp.TicketInspireSspRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigInteger;
import java.util.List;

/**
 * 广告券服务
 *
 * @author allen
 * @date 2017-12-05
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface TicketService {

    /**
     * 获取广告券
     *
     * @param request 请求参数
     * @return 如果没有可用的广告券，那么会返回<code>null</code>
     */
    @RequestMapping("/ticketService/get")
    Ticket get(@RequestBody TicketRequest request);

    /**
     * 曝光广告券
     * @param viewRequest 请求参数
     * @return 广告券
     * @throws IllegalTicketException 广告异常
     * @deprecated 从 2022/4/13 开始不再维护，如有改动需求请在 OpenLog 工程里更新。
     */
    @Deprecated
    @RequestMapping("/ticketService/view")
    Ticket view(@RequestBody ViewRequest viewRequest) throws IllegalTicketException;

    /**
     * 点击广告券
     *
     * @param clickRequest 请求参数
     * @return 广告券
     * @throws IllegalTicketException 广告异常
     * @deprecated 从 2022/4/13 开始不再维护，如有改动需求请在 OpenLog 工程里更新。
     */
    @Deprecated
    @RequestMapping("/ticketService/click")
    Ticket click(@RequestBody ClickRequest clickRequest) throws IllegalTicketException;

    /**
     * 返回所有的广告券，包括有效、无效，启用、禁用。
     * @return 广告券集合
     * @deprecated 建议避免使用这个方法，可能随时会关掉该接口。
     * @see #getTicketIdsByAdvertiserId(BigInteger)
     */
    @Deprecated
    @RequestMapping("/ticketService/getAllTickets")
    List<Ticket> getAllTickets();

    /**
     * 返回指定广告主下所有的广告券 ID
     * @param advertiserId 广告主ID
     * @return 广告券ID集合
     * @see #get(BigInteger)
     */
    @RequestMapping("/ticketService/getTicketIdsByAdvertiserId")
    List<BigInteger> getTicketIdsByAdvertiserId(@RequestParam("advertiserId") BigInteger advertiserId);

    /**
     * 返回广告券信息
     * @param ticketId 广告券ID
     * @return 广告券
     */
    @RequestMapping("/ticketService/getTicket")
    Ticket get(@RequestParam("ticketId") BigInteger ticketId);

    /**
     * 更新广告券状态
     * @param ticketId 广告券
     * @param status 需要更新到这个状态
     * @param reason 这个状态的原因，一般暂停才会用到
     * @return 更新是否成功
     * @see Ticket#STATUS_PAUSE
     * @see Ticket#PAUSE_REASON_OUT_OF_DAILYBUDGET
     * @throws IllegalTicketException 广告异常
     */
    @RequestMapping("/ticketService/updateTicketStatus")
    boolean updateTicketStatus(@RequestParam("ticketId") BigInteger ticketId,
                               @RequestParam("status") byte status,
                               @RequestParam("reason") int reason) throws IllegalTicketException;

    /**
     * 更新广告的所属广告组
     * @param ticketId 广告券
     * @param groupId 广告组
     */
    @RequestMapping("/ticketService/updateTicketGroupId")
    void updateTicketGroupId(@RequestParam("ticketId") BigInteger ticketId,
                             @RequestParam(name = "groupId", required = false) Long groupId);

    /**
     * 获取直投券
     * @param request 请求参数
     * @return 直投广告
     */
    @RequestMapping("/ticketService/getDirectTicket")
    Ticket getDirectTicket(@RequestBody AwardDto request);

    /**
     * 更新广告券状态
     * @param ticketId 广告券
     * @param status 需要更新到这个状态
     * @param reason 这个状态的原因，一般暂停才会用到
     * @param syncAdsmanager 是否请求后台系统，默认不请求
     * @return 更新是否成功
     * @see Ticket#STATUS_PAUSE
     * @see Ticket#PAUSE_REASON_OUT_OF_DAILYBUDGET
     * @throws IllegalTicketException
     */
    @RequestMapping("/ticketService/updateTicketStatusSyncAdsmanager")
    boolean updateTicketStatus(@RequestParam("ticketId") BigInteger ticketId,
                               @RequestParam("status") byte status,
                               @RequestParam("reason") int reason,
                               @RequestParam("syncAdsmanager") boolean syncAdsmanager)throws IllegalTicketException;

    /**
     * 从可用的广告券集中获取指定的广告
     */
    @RequestMapping("/ticketService/getAvailableTicket")
    TicketCache getAvailableTicket(@RequestParam("ticketId") BigInteger ticketId);

    /**
     * 获取广告票券列表
     *
     * @param request 请求参数
     * @return 如果没有可用的广告票券，那么会返回<code>null</code>
     */
    @RequestMapping("/ticketService/getCoupon")
    @Deprecated
    List<TicketCoupon> getCoupon(@RequestBody TicketCouponRequest request);

    /**
     * 绑定已展示的票券优惠码
     *
     * @param request 请求参数
     * @return 成功返回true
     */
    @RequestMapping("/ticketService/bindCoupon")
    @Deprecated
    Boolean bindCoupon(@RequestBody BindCouponRequest request);

    /**
     * 使用已绑定的票券优惠码
     *
     * @param request 请求参数
     * @return 成功返回true
     */
    @RequestMapping("/ticketService/useCoupon")
    @Deprecated
    Boolean useCoupon(@RequestBody BindCouponRequest request);

    /**
     * 校验前端缓存的票券码是否可删除
     *
     * @param request 请求参数
     * @return 返回可删除的列表
     */
    @RequestMapping("/ticketService/checkCoupon")
    @Deprecated
    List<CheckCoupon> checkCoupon(@RequestBody CheckCouponRequest request);

    /**
     * 获取激励视频
     *
     * @param request 请求参数
     * @return 如果没有可用的激励视频，那么会返回<code>null</code>
     */
    @Deprecated
    @RequestMapping("/ticketService/getInspire")
    TicketInspire getInspire(@RequestBody TicketInspireRequest request);

    /**
     * 获取激励视频-对外API
     *
     * @param request 请求参数
     * @return 如果没有可用的激励视频，那么会返回<code>null</code>
     */
    @Deprecated
    @RequestMapping("/ticketService/getInspireVideo")
    TicketInspireApi getInspireVideo(@RequestBody TicketInspireApiRequest request);

    /**
     * 获取激励视频-对外API（SSP专属）
     *
     * @param request 请求参数
     * @return 如果没有可用的激励视频，那么会返回<code>null</code>
     */
    @Deprecated
    @RequestMapping("/ticketService/getInspireVideoForSsp")
    TicketInspireSsp getInspireVideoForSsp(@RequestBody TicketInspireSspRequest request);

    /**
     * 获取激励视频结束页素材
     *
     * @param request 请求参数
     * @return 如果没有，那么会返回<code>null</code>
     */
    @Deprecated
    @RequestMapping("/ticketService/getInspireVideoEndCreative")
    TicketInspireEndCreative getInspireVideoEndCreative(@RequestBody TicketInspireEndCreativeRequest request);

    /**
     * 获取广告券
     *
     * @param request 请求参数
     * @return 如果没有可用的广告券，那么会返回<code>null</code>
     */
    @Deprecated
    @RequestMapping("/ticketService/ssp/getTicket")
    DirectTicketSsp getTicket(@RequestBody TicketRequest request);


    /**
     * 获取权益列表
     *
     * @param request 请求参数
     * @return 如果没有权益，那么会返回空
     */
    @RequestMapping("/ticketService/getTicketRights")
    List<TicketRights>  getTicketRights(@RequestBody AwardDto request);
}
