/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.resolve;

import com.bxm.adsprod.facade.resolve.UrlParam;
import com.bxm.adsprod.facade.resolve.UseFixedValue;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlParamResolver {
    public static final Logger logger = LoggerFactory.getLogger(UrlParamResolver.class);

    public static String generateUrlParam(String path, Object object) {
        if (object == null) {
            return "";
        }
        HashSet<Field> fieldSet = new HashSet<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null && tempClass != Object.class; tempClass = tempClass.getSuperclass()) {
            fieldSet.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        StringBuilder sb = new StringBuilder(path);
        sb.append("?");
        for (Field field : fieldSet) {
            if (!field.isAnnotationPresent(UrlParam.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            UrlParam urlParam = field.getAnnotation(UrlParam.class);
            UseFixedValue useFixedValue = field.getAnnotation(UseFixedValue.class);
            String value = null;
            if (useFixedValue == null) {
                try {
                    Object fieldValue = field.get(object);
                    if (fieldValue != null) {
                        value = fieldValue instanceof String ? (String)fieldValue : String.valueOf(fieldValue);
                    }
                }
                catch (IllegalAccessException e) {
                    logger.error("resolve field @UrlParam error ", (Throwable)e);
                }
            } else {
                value = useFixedValue.value();
            }
            if (value == null) {
                value = urlParam.defaultValue();
            }
            if (!StringUtils.isNotBlank((String)value)) continue;
            sb.append(urlParam.urlParamName()).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().trim();
    }

    public static Map<String, Object> generatePostParam(Object object) {
        if (object == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        HashSet<Field> fieldSet = new HashSet<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null && tempClass != Object.class; tempClass = tempClass.getSuperclass()) {
            fieldSet.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldSet) {
            if (!field.isAnnotationPresent(UrlParam.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            UrlParam urlParam = field.getAnnotation(UrlParam.class);
            UseFixedValue useFixedValue = field.getAnnotation(UseFixedValue.class);
            Object value = null;
            if (useFixedValue == null) {
                try {
                    value = field.get(object);
                }
                catch (IllegalAccessException e) {
                    logger.error("resolve field @UrlParam error ", (Throwable)e);
                }
            } else {
                value = useFixedValue.value();
            }
            if (value == null) {
                value = urlParam.defaultValue();
            }
            if (value != null) {
                paramsMap.put(urlParam.urlParamName(), value);
                continue;
            }
            paramsMap.put(urlParam.urlParamName(), "");
        }
        return paramsMap;
    }
}

