/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adsprod.model.so.rules.RuleSo;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketWhiteBlackSo
extends RuleSo {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketWhiteBlackSo.class);
    public static final String TYPE_WHITELIST = "1";
    public static final String TYPE_BLACKLIST = "2";
    private static final int VALUE_SPLIT_SIZE = 2;
    @JSONField(deserialize=false, serialize=false)
    private boolean blackList;
    @JSONField(deserialize=false, serialize=false)
    private Set<String> items = Sets.newHashSet();

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);
        String value = super.getRuleValue();
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        String[] strings = StringUtils.split((String)value, (char)'-');
        if (strings.length < 2) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid value format of 'TicketWhiteBlackSo',targetId={}, ruleType={}, ruleValue={}.", new Object[]{this.targetId, this.ruleType, ruleValue});
            }
            return;
        }
        if (strings.length > 2) {
            int startIndex = value.indexOf(45);
            strings = new String[]{StringUtils.substring((String)value, (int)0, (int)startIndex), StringUtils.substring((String)value, (int)(startIndex + 1), (int)value.length())};
        }
        String type = strings[0];
        String infos = strings[1];
        this.blackList = StringUtils.equals((String)TYPE_BLACKLIST, (String)type);
        String[] infoArray = StringUtils.split((String)infos, (char)',');
        this.items.addAll(Arrays.asList(infoArray));
    }

    public boolean isBlackList() {
        return this.blackList;
    }

    public Set<String> getItems() {
        return this.items;
    }
}

