package com.bxm.adsprod.facade.activity;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**  
* @Title: TicketKeyGenerator 
* @Description:  活动相关KEY的创建
* @author xavier  
* @date 2018年5月13日  
*/  
public final class ActivityKeyGenerator {


    public static class User {
        private User() {}

        public static KeyGenerator getUserActRecord(String uid) {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "USER", "RECORD", uid);
        }

        public static KeyGenerator getUserSmsRecord(String key) {
            return () -> KeyBuilder.build("AD", "ACTIVITY", "USER", "SMS", key);
        }
    }
}
