package com.bxm.adsprod.facade.advertiser;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigInteger;

/**
 * <h3>广告主服务</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface AdvertiserService {

    /**
     * 获取广告主余额
     *
     * @param advertiserId
     * @return
     */
    @RequestMapping("/advertiserService/getAdvertiserBalance")
    Long getAdvertiserBalance(@RequestParam("advertiserId") BigInteger advertiserId);


    /**
     * 获取广告主日消耗 排除CPA
     *
     * @param advertiserId
     * @return
     */
    @GetMapping("/advertiserService/getAdvertiserDailyConsume")
    Long getAdvertiserDailyConsume(@RequestParam("advertiserId") BigInteger advertiserId);


    /**
     * 获取广告主剩余日预算
     *
     * @param advertiserId
     * @return
     */
    @GetMapping("/advertiserService/getAdvertiserDailyBudget")
    Long getAdvertiserDailyBudget(@RequestParam("advertiserId") BigInteger advertiserId);

    /**
     * 启动广告主下面的广告计划
     * @param advertiserId
     * @param status
     * @param reason
     */
    @GetMapping("/advertiserService/openAdvertiserTicket")
    void openAdvertiserTicket(@RequestParam("advertiserId") BigInteger advertiserId, @RequestParam("status") Byte status, @RequestParam("reason") Integer reason);


    /**
     * 暂停广告主下的计划
     * @param advertiserId
     * @param reason
     */
    @GetMapping("/advertiserService/pauseAdvertiserTicket")
    void pauseAdvertiserTicket(@RequestParam("advertiserId") BigInteger advertiserId,@RequestParam("reason") Integer reason);


    /**
     * <p>增加广告主余额</p>
     * 这个接口执行后只会对实时监控的数据有效，不会对广告主本身的余额产生变化。一般在后台对广告主余额进行充值后进行调用，达到前后台数据一致的目的。
     *
     * @param advertiserId
     * @param incValue     增加金额，单位：厘
     * @return
     */
    @RequestMapping("/advertiserService/incrementBalance")
    Long incrementBalance(@RequestParam("advertiserId") BigInteger advertiserId,
                          @RequestParam("incValue") Long incValue);
}
