package com.bxm.adsprod.facade.ticket;

import java.math.BigInteger;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import com.bxm.adsprod.facade.award.MediaActivityRequest;
import com.bxm.adsprod.facade.award.OutSideDto;

/**
 * 礼券外投服务
 *
 * @author kk.xie
 **/
@Deprecated
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface TicketOutsideService {

    /**
     * 获取礼券外投跳转的广告主落地页地址
     *
     * @param assetId 素材ID
     * @param ip 用户IP
     * @return java.lang.String
     */
    @Deprecated // 此方法已过期
    @RequestMapping("/ticketOutsideService/getTicketUrl")
    String getTicketUrl(@RequestParam("assetId") String assetId,
                        @RequestParam("ip") String ip);

    /**
     * 获取礼券外投跳转的广告主落地页地址
     *
     * @return java.lang.String
     */
    @RequestMapping("/ticketOutsideService/getNewTicketUrl")
    String getNewTicketUrl(@RequestParam("assetId") String assetId,
                           @RequestParam("ip") String ip,
                           @RequestParam("isSupplement") String isSupplement,
                           @RequestParam(value = "ua", required = false) String userAgent,
                           @RequestParam(value = "referrer", required = false) String referrer,
                           @RequestParam(value = "spm", required = false) String spm);
    /**
     * 获取礼券外投跳转的广告主落地页地址
     *
     * @return java.lang.String
     */
    @RequestMapping("/ticketOutsideService/getNewActivityTicketUrl")
    String getNewActivityTicketUrl(@RequestBody OutSideDto outSideDto,
                           @RequestParam(value = "ua", required = false) String userAgent,
                           @RequestParam(value = "referrer", required = false) String referrer);


    @Deprecated // 此方法已过期
    @RequestMapping("/ticketOutsideService/getMediaRedirctUrl")
    String getMediaRedirctUrl(@RequestBody MediaActivityRequest request);

    /**
	 * 拼接广告位代号
     * @param url 参数字符串
	 * @param ticketId
	 * @return
	 */
	@RequestMapping("/ticketOutsideService/generateAdvertiserUrl")
	String generateAdvertiserUrl(@RequestParam("url") String url,
								 @RequestParam("ticketId")BigInteger ticketId,
								 @RequestParam("positionId")String positionId);


}
