package com.bxm.adsprod.facade.ticket.rtb;

import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@Data
public class PositionRtb implements Serializable {

    private static final long serialVersionUID = -919819840121789217L;

    public static final byte CONVERSION_CONTROL_TYPE_CVR = 1;
    public static final byte CONVERSION_CONTROL_TYPE_RATE = 2;

    public static final Integer FEEDBACK_MODE_HEAD_TICKET = 1;
    public static final Integer FEEDBACK_MODE_SUMMARY_CPA = 2;


    public interface AllSourceType {

        int KUAISHOU = 1;
        int BAIDU = 2;
        int GUANGDIANTONG = 3;
        int JULIANGYINQING = 4;
        int IQIYI = 5;
        int WANGYIYOUDAO = 6;
        int UC = 7;
        int XIMALAYA = 8;
        int JIGUANG=9;
        int ZFB=10;
        int QTT=11;
        int JIGUANGADX=12;
        int XIAOMI=13;
        int VIVO=14;
        int MEITUAN=15;
        int WIFI =16;
        int WEIBO =17;
        int BIGO = 18;
        int OPPO = 19;
        int SIGMOB_DSP =20;
        int DOMOB = 21;
        int MINTEGRAL = 22;
        int ADBEE = 23;
        int BiliBili = 24;
        int Ruishi = 25;
        int SouHu = 26;
        int YiXiao = 27;
        int QiMao = 28;
        int XunFei = 29;
        int KuaiKan = 30;
        int SIGMOB_INADS = 31;
        int BXM = 32;
        int PC360 = 33;
        int YOUKU = 34;
        int IFENG = 35;
        int WEIBODOWNLOAD = 36;
        int HUAWEI = 37;
        //支付宝灯火
        int ALIPAYDH = 38;
        int MENGRAN = 39;
        int BAICAI = 40;
    }

    private String positionId;

    /**
     * 秘钥token
     */
    private String token;

    /**
     * 客户ID
     */
    private String  customerId;

    /**
     * 数据源id
     */
    private String sourceId;

    /**
     * 扩展字段
     */
    private String extend;

    /**
     * 1 浅层  2 深层
     */
    private Byte targetType;

    /**
     * rtb 单层目标
     */
    private String targetOneRtb;

    /**
     * rtb 深层目标
     */
    private String targetTwoRtb;

    /**
     * cid商品类目 浅层
     */
    private String cidCategoryOne;
    /**
     * cid商品类目 深层
     */
    private String cidCategoryTwo;

    /**
     * 头部券jsonn
     * 助力器json
     */
    private String headTicketJson;
    private String helpTicketJson;

    /**
     * 来源 1快手 2 百度
     */
    private Integer sourceType;

    /**
     * 活动浅层
     * 活动深层
     */
    private String activityOne;
    private String activityTwo;

    /**
     * CVR 回传控制
     */
    @Deprecated
    private List<CvrControl> cvrControls;
    /**
     * 广告券 回传控制
     */
    private List<SpeedControl> ticketControls;
    /**
     * 活动 回传控制
     */
    private List<SpeedControl> activityControls;

    /**
     * 比例 回传控制
     */
    @Deprecated
    private List<CvrControl> rateControls;

    /**
     * 智能控制策略
     */
    private ControlStrategy controlStrategy;

    /**
     * 转化控制
     */
    private List<RatioControl> ratioControls;

    /**
     * 转化控制类型 1.cvr控制 2.扣量回传
     */
    @Deprecated
    private Byte conversionControlType;

    /**
     * 本次使用哪个头部券逻辑。 1 新的  0 老的（默认）
     * @see #newHeadList
     */
    private Byte isUse = 0;

    /**
     * 新的头部券逻辑
     */
    private List<PositionRtbHeadTicketGroup> newHeadList;

    /**
     * 当前广告位所属RTB平台的advertiserId
     */
    private String rtbAdvertiserId;

    /**
     * 是否开启活动参与回传限制：浅层
     * 0.否  1.是
     */
    private Integer enableActivityFeedbackLimitShallow;


    /**
     * 是否开启活动参与回传限制: 深层
     * 0.否  1.是
     */
    private Integer enableActivityFeedbackLimitDeep;


    /**
     * 允许回传的活动发券次序
     */
    private List<String> userActSeqList;

    /**
     * 限制cpa
     */
    private Integer cpa;

    /**
     * 回传方式：1.头部券回传 2.互动累加回传
     */
    private Integer feedbackMode;

    /**
     * 累加目标CPA,单位：厘
     */
    private Integer rtbTargetCpa;

    /**
     * 累加前置回传开关 0.关闭 1.开启
     */
    private Integer preSummaryFeedbackStatus;

    /**
     * 累加前置回传配置
     */
    private String preSummaryFeedbackConf;

    /**
     * 累加回传-智能托管状态 0.关闭 1.开启
     */
    private Integer summarySmartHostingStatus;

    /**
     * 累加回传-智能托管配置
     */
    private String summarySmartHostingConf;

    @Data
    public class PositionRtbHeadTicketGroup {
        /**
         * 组ID
         */
        private Long id;

        /**
         * 是否使用算法排序，1排序 0不排序
         */
        private Short isAlgo = 0;

        private Integer flow = 100;

        private String positionId;

        private String headTicketJson;

        List<TargetBXM> headTicketList;

        public Boolean getAlgo(){
            return this.isAlgo ==1;
        }
    }

    @Data
    public static class TargetBXM {
        /**
         * bxm 单层目标
         * bxm 深层目标
         * 如果是头部券，则只有一个券id,不会存在多个的情况； 如果是助力券则是 券列表，多个以逗号隔开
         * 流量分配
         */
        private Integer targetOneBxm;
        private Integer targetTwoBxm;
        private String ticketIds;
        private Integer flow;
        /**
         * 回传比例，取值范围：0-1，1 表示 100%。
         */
        private Double ratio;
    }

    @Data
    @Deprecated
    public static class CvrControl {
        /**
         * 自增主键
         */
        private Long id;
        /**
         * <p>广告组 ID，一般根据不同的平台有不同的含义。</p>
         * <p>可以为空，为空则表示匹配当前广告位任何广告组 ID。如果冲突，则优先取 广告组 ID 粒度的配置。</p>
         */
        private String adGroupId;
        /**
         * <p>控制的 cvr、控制的比例，这取决于控制的类型。</p>
         *
         * <p>浅层转化 扣量比例，取值范围：0-1，1 表示 100%。</p>
         */
        private double cvr;
        /**
         * <p>深层转化 扣量比例，取值范围：0-1，1 表示 100%。</p>
         * 从这个<a href="https://alidocs.dingtalk.com/i/team/BpLmkK6448BpPm2g/docs/BpLmkwPNA0r1vm2g">版本「Mintegral和爱奇艺支持双目标扣量」</a>开始使用的
         */
        private double deepCvr;
        /**
         * 开始时间，格式：HH:mm:ss
         */
        private String startTime;
        /**
         * 结束时间，格式：HH:mm:ss
         */
        private String endTime;
        /**
         * 启用状态
         */
        private boolean enable;
    }

    @Data
    public static class RatioControl {
        /**
         * 自增主键
         */
        private Long id;
        /**
         * <p>广告组 ID，一般根据不同的平台有不同的含义。</p>
         * <p>可以为空，为空则表示匹配当前广告位任何广告组 ID。如果冲突，则优先取 广告组 ID 粒度的配置。</p>
         */
        private String adGroupId;
        /**
         * <p>控制的 cvr、控制的比例，这取决于控制的类型。</p>
         */
        private Double cvr;

        /**
         * <p>浅层转化 扣量比例，取值范围：0-1，1 表示 100%。</p>
         */
        private Double shallowRatio;

        /**
         * <p>深层转化 扣量比例，取值范围：0-1，1 表示 100%。</p>
         * 从这个<a href="https://alidocs.dingtalk.com/i/team/BpLmkK6448BpPm2g/docs/BpLmkwPNA0r1vm2g">版本「Mintegral和爱奇艺支持双目标扣量」</a>开始使用的
         */
        private Double deepRatio;

        /**
         * <p>效果成本控制金额，单位：元，小数点保留 2 位</p>
         */
        private Double cost;

        /**
         * <p>非转化回传限制次数</p>
         */
        private Integer limitUnconv;

        /**
         * 开始时间，格式：HH:mm:ss
         */
        private String startTime;

        /**
         * 结束时间，格式：HH:mm:ss
         */
        private String endTime;

        /**
         * 启用状态
         */
        private boolean enable;

        public boolean isEnableCvrControl() {
            return Objects.nonNull(cvr);
        }

        public boolean isEnableDeductionControl() {
            return Objects.nonNull(shallowRatio) || Objects.nonNull(deepRatio);
        }

        public boolean isEnableCostControl() {
            return Objects.nonNull(cost);
        }

        /**
         * @return 非转化回传次数是否不限
         */
        public boolean isUnlimitUnconvs() {
            return Objects.isNull(limitUnconv);
        }
    }

    @Data
    public static class SpeedControl {

        private Long id;
        /**
         * <p>广告组 ID，一般根据不同的平台有不同的含义。</p>
         * <p>可以为空，为空则表示匹配当前广告位任何广告组 ID。如果冲突，则优先取 广告组 ID 粒度的配置。</p>
         */
        private String adGroupId;
        /**
         * 广告券 ID，活动配置下没有值。
         */
        private String adTicketId;
        /**
         * 行为类型
         */
        private String convType;
        /**
         * 控制回传数量
         */
        private Integer count;
        /**
         * 启用日期，格式：yyyy-MM-dd
         */
        private String date;
        /**
         * 开始时间，格式：HH:mm:ss
         */
        private String startTime;
        /**
         * 结束时间，格式：HH:mm:ss
         */
        private String endTime;
        /**
         * 启用状态
         */
        private boolean enable;
    }

    @Data
    public static class ControlStrategy {

        public static final int DURATION_DAY = 1;
        public static final int DURATION_HOUR = 2;

        public static final int STRATEGY_ORDER_CONV_COUNT = 1;
        public static final int STRATEGY_ORDER_CVR = 2;

        /**
         * 时间控制维度
         * @see #DURATION_DAY
         * @see #DURATION_HOUR
         */
        private Integer duration = DURATION_DAY;
        /**
         * 补量策略
         * @see #STRATEGY_ORDER_CONV_COUNT
         * @see #STRATEGY_ORDER_CVR
         */
        private Integer plusStrategy = STRATEGY_ORDER_CONV_COUNT;
    }

    public boolean isKuaishou() {
        return this.getSourceType() == AllSourceType.KUAISHOU;
    }

    public boolean isBaidu() {
        return this.getSourceType() == AllSourceType.BAIDU;
    }

    public boolean isGuangDianTong() {
        return this.getSourceType() == AllSourceType.GUANGDIANTONG;
    }

    /**
     * 是 CVR 控制类型
     * @return 当没有指定 {@link #conversionControlType} 时，默认：true
     * @see #CONVERSION_CONTROL_TYPE_CVR
     */
    @Deprecated
    public boolean isCvrControl() {
        if (Objects.isNull(this.conversionControlType)) {
            // 当没有值时，默认为 CONVERSION_CONTROL_TYPE_CVR
            return true;
        }
        return Objects.equals(this.conversionControlType, CONVERSION_CONTROL_TYPE_CVR);
    }

    /**
     * 是 比例 控制类型
     * @return 当没有指定 {@link #conversionControlType} 时，默认：false
     * @see #CONVERSION_CONTROL_TYPE_RATE
     */
    @Deprecated
    public boolean isDeductionControl() {
        return Objects.equals(this.conversionControlType, CONVERSION_CONTROL_TYPE_RATE);
    }

    /**
     * 当前配置是 CVR 控制或扣量控制。
     * @return CVR or deduction
     */
    public boolean isCvrOrDeductionControl() {
        return CollectionUtils.isNotEmpty(getRatioControls());
    }

    /**
     * 广告位使用了回传控制功能，包括所有的类型。
     *
     * @return 配置了任何一种回传控制，则返回 true
     */
    public boolean isControlForAnyType() {
        return CollectionUtils.isNotEmpty(this.getCvrControls())
                || CollectionUtils.isNotEmpty(this.getRateControls())
                || CollectionUtils.isNotEmpty(this.getTicketControls())
                || CollectionUtils.isNotEmpty(this.getActivityControls())
                || CollectionUtils.isNotEmpty(this.getRatioControls());
    }

    public boolean isEnableActivityFeedbackLimitShallow() {
        return Objects.equals(enableActivityFeedbackLimitShallow, 1);
    }

    public boolean isEnableActivityFeedbackLimitDeep() {
        return Objects.equals(enableActivityFeedbackLimitDeep, 1);
    }

    public boolean isFeedbackModeHeadTicket() {
        return feedbackMode == null || Objects.equals(feedbackMode, FEEDBACK_MODE_HEAD_TICKET);
    }

    public boolean isFeedbackModeSummaryCpa() {
        return Objects.equals(feedbackMode, FEEDBACK_MODE_SUMMARY_CPA);
    }

    public boolean isPreSummaryFeedback() {
        return Objects.equals(preSummaryFeedbackStatus, 1);
    }

    public boolean isEnableSmartHosting() {
        return isFeedbackModeSummaryCpa() && Objects.equals(summarySmartHostingStatus, 1);
    }

}