package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import java.util.*;

/**
 * @author allen
 * @since 1.0.0
 */
public class PositionGroupRuleSo extends AbstractSixRule {

    @JSONField(deserialize = false, serialize = false)
    private final List<Entry> entries = Lists.newArrayList();
    @Override
    protected char itemSeparatorChar() {
        return '|';
    }
    @Override
    protected void addItem(String one, String two, String three,String four,String five,String six) {
        Entry e = new Entry();
        e.setGroupId(one);
        e.setLimit(NumberUtils.toLong(two));
        e.setPrice(NumberUtils.toLong(three));
        e.setPositions(Sets.newHashSet(StringUtils.split(four, '^')));
        e.setCpaPrice(NumberUtils.toLong(five, 0));
        e.setDeepCpaPrice(NumberUtils.toLong(six,0));
        entries.add(e);
    }

    public Collection<Entry> getEntries() {
        return Collections.unmodifiableCollection(entries);
    }


    public static class Entry {
        private String groupId;
        private long limit;
        /**
         * cpc 出价
         */
        private long price;
        /**
         * cpa 出价
         */
        private long cpaPrice;

        /**
         * 深层cpa 出价
         */
        private long deepCpaPrice;
        private Set<String> positions;

        public long getCpaPrice() {
            return cpaPrice;
        }

        public void setCpaPrice(long cpaPrice) {
            this.cpaPrice = cpaPrice;
        }

        public long getDeepCpaPrice() {
            return deepCpaPrice;
        }

        public void setDeepCpaPrice(long deepCpaPrice) {
            this.deepCpaPrice = deepCpaPrice;
        }

        public String getGroupId() {
            return groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public long getLimit() {
            return limit;
        }

        public long getPrice() {
            return price;
        }

        public void setPrice(long price) {
            this.price = price;
        }

        public void setLimit(long limit) {
            this.limit = limit;
        }

        public Set<String> getPositions() {
            return positions;
        }

        public void setPositions(Set<String> positions) {
            this.positions = positions;
        }
    }
}
