package com.bxm.adsprod.facade.advertiser;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description 站内户权重 推送类
 *
 * @author hxpeng
 * <p>
 * Date 2018/12/17 17:41
 */
public class StationUserWeightPushParam implements Serializable {

    private static final long serialVersionUID = -9114639295343026335L;

    /**
     * 站内户权重ID
     */
    private Long stationUserWeightId;

    /**
     * 券ID集合字符串;  like: ,xx,xx,xx,x,x,x,x, (前后都有逗号)
     */
    private String ticketIdsStr;

    /**
     * 是否限制广告位
     */
    private Boolean limitPositionFlag;

    /**
     * 广告位ID集合; like: ,xx,x,x,x,x,x,xx, (前后都有逗号)
     */
    private String positionIdsStr;

    /**
     * 站内户权重计划消耗额
     */
    private BigDecimal weightPlanConsume;

    /**
     * 权重系数
     */
    private Double weightCoefficient;

    /**
     * 计划状态;
     * 1：已完成；
     * 0：进行中；
     */
    private Byte status;

    /**
     * 站内户权重的广告券类型
     */
    private Integer ticketTagCode;

    public Long getStationUserWeightId() {
        return stationUserWeightId;
    }

    public void setStationUserWeightId(Long stationUserWeightId) {
        this.stationUserWeightId = stationUserWeightId;
    }

    public String getTicketIdsStr() {
        return ticketIdsStr;
    }

    public void setTicketIdsStr(String ticketIdsStr) {
        this.ticketIdsStr = ticketIdsStr;
    }

    public Boolean getLimitPositionFlag() {
        return limitPositionFlag;
    }

    public void setLimitPositionFlag(Boolean limitPositionFlag) {
        this.limitPositionFlag = limitPositionFlag;
    }

    public String getPositionIdsStr() {
        return positionIdsStr;
    }

    public void setPositionIdsStr(String positionIdsStr) {
        this.positionIdsStr = positionIdsStr;
    }

    public BigDecimal getWeightPlanConsume() {
        return weightPlanConsume;
    }

    public void setWeightPlanConsume(BigDecimal weightPlanConsume) {
        this.weightPlanConsume = weightPlanConsume;
    }

    public Double getWeightCoefficient() {
        return weightCoefficient;
    }

    public void setWeightCoefficient(Double weightCoefficient) {
        this.weightCoefficient = weightCoefficient;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Integer getTicketTagCode() {
        return ticketTagCode;
    }

    public void setTicketTagCode(Integer ticketTagCode) {
        this.ticketTagCode = ticketTagCode;
    }

    /**
     * Description: 判断券ID 是否存在在 ticketIdsStr中
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/26 14:39
     *
     * @param ticketId 券ID
     * @return java.lang.Boolean
     * @author hxpeng
     */
    public Boolean checkTicketExist(Long ticketId) {
        if (null == ticketId) {
            throw new NullPointerException();
        }
        if (StringUtils.isBlank(this.ticketIdsStr)) {
            return false;
        }
        String ticketIdStrRegex = "," + ticketId.toString() + ",";
        return this.ticketIdsStr.contains(ticketIdStrRegex);
    }
}
