package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/**
 * 票券码.</br>
 * @author zhengwangeng
 * @date 2019年05月24日上午10:53:28
 */
public class TicketCouponsCode implements Serializable {
    private static final long serialVersionUID = 4368329874159718574L;

    /**
     * 状态：0未使用，1待使用，2已使用
     */
    public static final short TEMP_LOCK = -1;//临时码(不入库)
    public static final short STATUS_UNUSED = 0;
    public static final short STATUS_RECEIVED = 1;
    public static final short STATUS_USED = 2;

    private BigInteger id;
    private Byte status;
    private Date firstShowTime;
    private Date useTime;
    private String usePositionId;
    private String bindDeviceNo;
    private String couponsCode;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Date getFirstShowTime() {
        return firstShowTime;
    }

    public void setFirstShowTime(Date firstShowTime) {
        this.firstShowTime = firstShowTime;
    }

    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    public String getUsePositionId() {
        return usePositionId;
    }

    public void setUsePositionId(String usePositionId) {
        this.usePositionId = usePositionId;
    }

    public String getBindDeviceNo() {
        return bindDeviceNo;
    }

    public void setBindDeviceNo(String bindDeviceNo) {
        this.bindDeviceNo = bindDeviceNo;
    }

    public String getCouponsCode() {
        return couponsCode;
    }

    public void setCouponsCode(String couponsCode) {
        this.couponsCode = couponsCode;
    }

    public enum AdCouponsStatus {
        /**
         * 状态：0未使用，1待使用，2已使用
         */
        TEMP_LOCK(TicketCouponsCode.TEMP_LOCK,"锁定"),//临时码(不入库)
        STATUS_UNUSED(TicketCouponsCode.STATUS_UNUSED,"未使用"),
        STATUS_RECEIVED(TicketCouponsCode.STATUS_RECEIVED,"待使用"),
        STATUS_USED(TicketCouponsCode.STATUS_USED,"已使用");

        private short status;
        private String name;
        AdCouponsStatus(short status, String name){
            this.status = status;
            this.name = name;
        }

        public static String getName(short status){
            for (AdCouponsStatus status1: AdCouponsStatus.values()){
                if(status == status1.status){
                    return status1.name;
                }
            }
            return "-";
        }

        public short getStatus() {
            return status;
        }

        public String getName() {
            return name;
        }
    }
}
