package com.bxm.adsprod.model.dao.media;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.bxm.adsprod.facade.media.InspireVideoConfig;
import com.bxm.adsprod.facade.media.PositionAdx;

/**
 *
 * @author allen
 * @since V1.0.0 2018/01/04
 */
public class PositionDao implements Serializable {

    private static final long serialVersionUID = -2980029479482238670L;

    private String mediaId;
    private String positionId;
    private String positionName;
    private String domainCode;

    /**
     * 媒体一级分类
     */
    private String mediaClassId;

    /**
     * 媒体二级分类
     */
    private  String mediaChildClassId;

    /**
     * 开发者id
     */
    private  String providerId;

    /**
     * （媒体）来源类型 (h5 app )
     */
    private  String mediaSysType;

    /**
     * 广告位入口场景（类别）（banal，浮标）
     */
    private  String positionEntrance;

    /**
     * 券码投放?0:关闭，1:开启 ？true开启， false 关闭
     */
    private Boolean couponsPutinFlag;

    /**
     * 券码投放浮标位尺寸ID
     */
    private Long couponsIconSize;

    /**
     * 券码投放展示位尺寸ID
     */
    private Long couponsCreativeSize;

    /**
     * 投放方式类型：1常规投放，2券码类投放，3激励视频投放
     */
    private Byte putinType;

    /**
     * 上报地址
     */
    private String reportUrl;

    /**
     * 广告位场景
     */
    private Byte positionScene;

    /**
     * 广告位adx配置信息
     */
    private PositionAdx positionAdx;

    /**
     * 激励视频投放配置列表
     */
    private List<InspireVideoConfig> inspireVideoConfigs;

    public String getMediaId() {
        return mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Boolean getCouponsPutinFlag() {
        return couponsPutinFlag;
    }

    public void setCouponsPutinFlag(Boolean couponsPutinFlag) {
        this.couponsPutinFlag = couponsPutinFlag;
    }

    public Long getCouponsIconSize() {
        return couponsIconSize;
    }

    public void setCouponsIconSize(Long couponsIconSize) {
        this.couponsIconSize = couponsIconSize;
    }

    public Long getCouponsCreativeSize() {
        return couponsCreativeSize;
    }

    public void setCouponsCreativeSize(Long couponsCreativeSize) {
        this.couponsCreativeSize = couponsCreativeSize;
    }

    public Byte getPutinType() {
        return putinType;
    }

    public void setPutinType(Byte putinType) {
        this.putinType = putinType;
    }

    public String getReportUrl() {
        return reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public PositionAdx getPositionAdx() {
        return positionAdx;
    }

    public void setPositionAdx(PositionAdx positionAdx) {
        this.positionAdx = positionAdx;
    }

    public String getMediaClassId() {
        return mediaClassId;
    }

    public void setMediaClassId(String mediaClassId) {
        this.mediaClassId = mediaClassId;
    }

    public String getMediaChildClassId() {
        return mediaChildClassId;
    }

    public void setMediaChildClassId(String mediaChildClassId) {
        this.mediaChildClassId = mediaChildClassId;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getMediaSysType() {
        return mediaSysType;
    }

    public void setMediaSysType(String mediaSysType) {
        this.mediaSysType = mediaSysType;
    }

    public String getPositionEntrance() {
        return positionEntrance;
    }

    public void setPositionEntrance(String positionEntrance) {
        this.positionEntrance = positionEntrance;
    }

    public List<InspireVideoConfig> getInspireVideoConfigs() {
        return inspireVideoConfigs;
    }

    public void setInspireVideoConfigs(List<InspireVideoConfig> inspireVideoConfigs) {
        this.inspireVideoConfigs = inspireVideoConfigs;
    }

    public Byte getPositionScene() {
        return positionScene;
    }

    public void setPositionScene(Byte positionScene) {
        this.positionScene = positionScene;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
