package com.bxm.adsprod.facade.commons;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * <h3>推送服务</h3>
 *
 * <p>将数据推送到<code>serviceName</code>服务，对应的服务接收到请求后，会根据<code>parameters</code>参数约定来生成缓存的KEY，最后将<code>data</code>数据更新到缓存中。</p>
 * @author allen
 * @date 2017-12-04
 * @deprecated 不再推荐使用。建议使用来自<code>warcar-integration</code>的{@link com.bxm.warcar.integration.pushable.CachePushableService}。
 * 如果集成<code>spring-boot-starter-warcar-integration</code>，那么可直接引用即可。
 */
@Deprecated
@FeignClient(name = AdsprodFacadeConstants.PUSHABLE_NAME)
public interface CachePushableService {

    /**
     * 推送数据到缓存。
     *
     * @param serviceName 服务名
     * @param parameters 参数列表
     * @param data 数据
     * @return 推送反馈描述信息
     * @see com.bxm.warcar.cache.push.Pushable
     * @see CachePushableFields
     * @throws CachePushException
     * @deprecated 建议使用 {@link #push(CachePushableEntity)}
     */
    @Deprecated
    @RequestMapping(value = "/cachePushableService/push0/{serviceName}", method = RequestMethod.POST)
    String push(@PathVariable("serviceName") String serviceName,
                @RequestParam Map<String, Object> parameters,
                @RequestBody byte[] data) throws CachePushException;

    /**
     * 推送数据到缓存
     * @param entity 数据内容体
     * @return 推送反馈描述信息。
     */
    @RequestMapping(value = "/cachePushableService/push", method = RequestMethod.POST)
    String push(@RequestBody CachePushableEntity entity) throws CachePushException;
}
