package com.bxm.adsprod.facade.position;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 广告位分桶配置
 *
 * @author zhangdong
 * @date 2023/8/22
 */
@Data
public class PositionBucketConfig implements Serializable {

    /**
     * 分桶id
     */
    private Integer bucketId;
    /**
     * 分桶比例
     */
    private Integer bucketRatio;
    /**
     * 分桶下的次序配置
     */
    private Map<Integer, List<PositionSequenceConfig>> seqConfigMap;


    /**
     * 分桶类型  0常规 1 测试
     */
    private Integer bucketType;

    /**
     * 测试分桶的曝光限制
     */
    private Integer testBucketCountLimit;

    public boolean isTestBucketType() {
        return bucketType != null && bucketType == 1;
    }
}
