package com.bxm.adsprod.facade.ticket.rtb;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * rtb累加-智能托管配置
 */
@Data
@Accessors(chain = true)
public class HostingConfig {
    public static final String ACCOUNT_DIMENSION = "ACCOUNT";

    /**
     * 账户：ACCOUNT，其他为广告组id
     */
    private String dimension;
    /**
     * 目标roi
     */
    private BigDecimal expectRoi;

    /**
     * 最低考核CPA
     */
    private BigDecimal minCpa;

    /**
     * 最高考核CPA
     */
    private BigDecimal maxCpa;

    public boolean isAccount() {
        return Objects.equals(dimension, ACCOUNT_DIMENSION);
    }

}