package com.bxm.adsprod.facade.position;

import lombok.Data;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * 时间范围（小时分钟 如12:03）
 * @author tangxiao
 * @date 2023/10/20
 * @since 1.0
 */
@Data
public class HourMinuteRange {
    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    public boolean hitRange(LocalTime localTime) {
        LocalTime startLocalTime = LocalTime.parse(startTime, DateTimeFormatter.ofPattern("HH:mm"));
        LocalTime endLocalTime = LocalTime.parse(endTime, DateTimeFormatter.ofPattern("HH:mm"));
        return localTime.isAfter(startLocalTime) && localTime.isBefore(endLocalTime);
    }
}
