package com.bxm.adsprod.facade.ticket;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;

@Data
public class TicketEcologyExplore {
    private Long id;

    private Long ticketId;

    /**
     * 是否开启生态探索（0 开启  1 关闭）
     */
    private Short status;

    /**
     * 1全天  2 指定
     */
    private Short launchType;

    private LocalDate startDate;

    private LocalDate endDate;

    private LocalTime dayStartTime;

    private LocalTime dayEndTime;

    private Long budgetDaily;

    private Long ticketPositionBudget;

    private Long ticketPositionCost;

    private Long ticketPositionConsume;


    /**
     * 点击出价系数
     */
    private BigDecimal clickPriceCoefficient;


    /**
     * 全局开关 0关闭 1开启
     */
    private Integer globalSwitch;
    /**
     * 广告位开关 0关闭 1开启
     */
    private Integer positionSwitch;

    private String sequence;

    private List<String> sequenceList;
}