package com.bxm.adsprod.facade.ticket;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 广告位最终出价
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TicketPositionPrice implements Serializable {

    private static final long serialVersionUID = 375355229334706277L;

    /**
     * cpc 出价
     */
    private Long cpcPrice;
    /**
     * cpa 出价
     */
    private Long cpaPrice;

    /**
     * 深层cpa 出价
     */
    private Long deepCpaPrice;

    private Long configId;

    /**
     * 建议cpc价格
     */
    private Long recommendCpcPrice;

    /**
     * 出价建议限制预算
     */
    private Long recommendBudget;
}
