package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * <h3>广告票券信息</h3>
 *
 * @author kerry.jiang
 * @date 2019/5/20 17:55
 */
public class TicketCoupon implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 广告券ID
     */
    private BigInteger id;
    /**
     * 广告券名称
     */
    private String name;
    /**
     * 第三方埋点地址
     */
    private List<String> bury_point_urls;
    /**
     * 开始时间
     */
    private Date validStartDate;
    /**
     * 结束时间
     */
    private Date validEndDate;
    /**
     * APP下载地址
     */
    private String url;
    /**
     * APP包名
     */
    private String package_name;
    /**
     * 票券类型,0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    private Integer use_type;
    /**
     * 票券优惠码
     */
    private String coupons_code;
    /**
     * 优惠码内容
     */
    private String coupons_content;
    /**
     * 优惠码说明
     */
    private String coupons_intro;
    /**
     * 浮标素材ID
     */
    private BigInteger icon_id;
    /**
     * 浮标素材图片
     */
    private String icon_img;
    /**
     * 展示素材ID
     */
    private BigInteger creative_id;
    /**
     * 展示素材上图
     */
    private String creative_top_img;
    /**
     * 展示素材下图
     */
    private String creative_bottom_img;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getBury_point_urls() {
        return bury_point_urls;
    }

    public void setBury_point_urls(List<String> bury_point_urls) {
        this.bury_point_urls = bury_point_urls;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPackage_name() {
        return package_name;
    }

    public void setPackage_name(String package_name) {
        this.package_name = package_name;
    }

    public Integer getUse_type() {
        return use_type;
    }

    public void setUse_type(Integer use_type) {
        this.use_type = use_type;
    }

    public String getCoupons_code() {
        return coupons_code;
    }

    public void setCoupons_code(String coupons_code) {
        this.coupons_code = coupons_code;
    }

    public String getCoupons_content() {
        return coupons_content;
    }

    public void setCoupons_content(String coupons_content) {
        this.coupons_content = coupons_content;
    }

    public String getCoupons_intro() {
        return coupons_intro;
    }

    public void setCoupons_intro(String coupons_intro) {
        this.coupons_intro = coupons_intro;
    }

    public BigInteger getIcon_id() {
        return icon_id;
    }

    public void setIcon_id(BigInteger icon_id) {
        this.icon_id = icon_id;
    }

    public String getIcon_img() {
        return icon_img;
    }

    public void setIcon_img(String icon_img) {
        this.icon_img = icon_img;
    }

    public BigInteger getCreative_id() {
        return creative_id;
    }

    public void setCreative_id(BigInteger creative_id) {
        this.creative_id = creative_id;
    }

    public String getCreative_top_img() {
        return creative_top_img;
    }

    public void setCreative_top_img(String creative_top_img) {
        this.creative_top_img = creative_top_img;
    }

    public String getCreative_bottom_img() {
        return creative_bottom_img;
    }

    public void setCreative_bottom_img(String creative_bottom_img) {
        this.creative_bottom_img = creative_bottom_img;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
