package com.bxm.adsprod.facade.ticket;

import lombok.Data;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

@Data
public class TicketExplore {

    private Long ticketId;

    /**
     * 是否开启加速探索（0 开启  1 关闭）
     */
    private Short status = 0;

    /**
     * 全局开关 0关闭 1开启
     */
    private Integer globalSwitch;
    /**
     * 广告位开关 0关闭 1开启
     */
    private Integer positionSwitch;

    private LocalDate startDate;

    private LocalDate endDate;

    private LocalTime dayStartTime;

    private LocalTime dayEndTime;

    /**
     * 1全天  2 指定
     */
    private Short launchType;

    private Long budgetDaily = 2000000L;

    private String sequence;

    private Integer clickThreshold = 200;

    private List<String> sequenceList;

    /**
     * 0 不激进探索 1激进探索
     */
    private Integer radical = 0;

    /**
     * 券-广告位探索预算
     */
    private Long ticketPositionBudget;
    /**
     * 券-广告位探索成本
     */
    private Long ticketPositionCost;
    /**
     * 券-广告位探索消耗
     */
    private Long ticketPositionConsume;


    public Boolean isRedical() {
        return radical != null && radical == 1;
    }

    public Boolean isOpen() {
        return status != null && status == 0;
    }

    public Boolean isGlobalEnable() {
        return globalSwitch != null && globalSwitch == 1;
    }

    public Boolean isPositionEnable() {
        return positionSwitch != null && positionSwitch == 1;
    }


    public Boolean isAppoint() {
        return launchType != null && launchType == 2;
    }
}