package com.bxm.adsprod.facade.position;

import lombok.Data;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * 时间范围（小时分钟 如12:03）
 * @author tangxiao
 * @date 2023/10/20
 * @since 1.0
 */
@Data
public class HourMinuteRange {
    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

   public LocalTime getStartLocalTime() {
       return LocalTime.parse(startTime, DateTimeFormatter.ofPattern("HH:mm"));
    }

    public LocalTime getEndLocalTime() {
        return LocalTime.parse(endTime, DateTimeFormatter.ofPattern("HH:mm"));
    }

    public boolean hitRange(LocalTime localTime) {
        return localTime.isAfter(getStartLocalTime()) && localTime.isBefore(getEndLocalTime());
    }
}
