package com.bxm.adsprod.facade.ticket.rtb;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * rtb累加-智能托管配置
 */
@Data
@Accessors(chain = true)
public class SummarySmartHostingConfig {
    public static final String ACCOUNT_FIELD = "ACCOUNT";

    /**
     * 账户配置
     */
    private Config accountConf;

    /**
     * 广告组累加前置回传数
     */
    private List<Config> adGroupConf;

    @Data
    @Accessors(chain = true)
    public static class Config {
        private String adGroupId;
        /**
         * 兜底roi
         */
        private Double minRoi;

        /**
         * 投放目标CPA
         */
        private Double cpa;

        /**
         * 超成本比 （实际投放效果成本/）
         */
        private Double excessRatio;
    }

}