package com.bxm.adsprod.service.http.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigInteger;

/**
 * <h3>Http Implementation.</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/19
 */
@RestController
public class AdvertiserServiceController {

    @Reference(version = "1.0.0")
    private AdvertiserService advertiserService;

    @RequestMapping("/advertiser/balance")
    public Long getAdvertiserBalance(BigInteger advertiserId) {
        return advertiserService.getAdvertiserBalance(advertiserId);
    }

    @RequestMapping("/advertiser/increment/balance")
    public Long incrementBalance(BigInteger advertiserId, Long incValue) {
        return advertiserService.incrementBalance(advertiserId, incValue);
    }
}
