package com.bxm.adsprod.service.http.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.commons.CachePushException;
import com.bxm.adsprod.facade.commons.CachePushableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author allen
 * @since V1.0.0 2017/12/28
 */
@Api
@RestController
public class CachePushableServiceController {

    @Reference(version = "1.0.0")
    private CachePushableService cachePushableService;


    @ApiOperation(value = "缓存推送")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "serviceName", required = true, dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "parameters", required = true, dataType = "map", paramType = "query"),
            @ApiImplicitParam(name = "data", required = true, dataType = "byte", paramType = "body")
    })
    @RequestMapping(value = "/cache/push/{serviceName}", method = RequestMethod.POST)
    public String push(@PathVariable("serviceName") String serviceName,
                       @RequestParam Map<String, Object> parameters,
                       @RequestBody byte[] data) {
        try {
            return cachePushableService.push(serviceName, parameters, data);
        } catch (CachePushException e) {
            return e.getMessage();
        }
    }
}
