package com.bxm.adsprod.service.http.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.ticket.*;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigInteger;
import java.util.List;

/**
 * <h3>Http implementation.</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/19
 */
@Api("广告券相关服务")
@RestController
public class TicketServiceController {

    @Reference(version = "1.0.0")
    private TicketService ticketService;

    @RequestMapping(value = "/ticket/view", method = RequestMethod.GET)
    public Ticket view(TicketRequest ticketRequest) throws NoValidTicketException {
        return ticketService.get(ticketRequest);
    }

    @RequestMapping("/ticket/click")
    public Ticket click(ClickRequest clickRequest) throws IllegalTicketException {
        return ticketService.click(clickRequest);
    }

    @RequestMapping(value = "/ticket/all", method = RequestMethod.GET)
    public List<Ticket> getAllTickets() {
        return ticketService.getAllTickets();
    }

    @RequestMapping("/ticket/get")
    public Ticket get(BigInteger ticketId) {
        return ticketService.get(ticketId);
    }

    public boolean updateTicketStatus(BigInteger ticketId, byte status, int reason) {
        return false;
    }
}
