package com.bxm.adsprod.integration.adsmanager;

import com.bxm.adsprod.common.utils.PathUtils;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.math.BigInteger;
import java.util.Map;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@Configuration
@EnableConfigurationProperties(AdsmanagerConfiguration.class)
public class AdsmanagerServiceHttpImpl implements AdsmanagerService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdsmanagerServiceHttpImpl.class);

    @Autowired
    private AdsmanagerConfiguration configuration;

    @Override
    public boolean updateAdTicket(BigInteger ticketId, byte status, int reason) {
        RestTemplate restTemplate = new RestTemplateBuilder().setConnectTimeout(6000).build();
        Map<String, Object> uriVariables = Maps.newHashMap();
        uriVariables.put("id", ticketId);
        uriVariables.put("status", status);
        uriVariables.put("reason", reason);
        String url = PathUtils.appendToHost(configuration.getHost(), "adsmanager",
                "updateAdTicket?id={id}&status={status}&reason={reason}");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access url: {}, parameters: {}", url, uriVariables);
        }
        HttpEntity<?> entity = HttpEntity.EMPTY;
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, entity, String.class, uriVariables);
        RestfulResponse restfulResponse = JsonHelper.convert(responseEntity.getBody(), RestfulResponse.class);
        return restfulResponse.isSuccessed();
    }
}
