/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.activity;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.activity.ActivityKeyGenerator;
import com.bxm.adsprod.facade.activity.ActivityService;
import com.bxm.adsprod.facade.activity.InfoActivity;
import com.bxm.adsprod.facade.activity.WeightEntry;
import com.bxm.adsprod.model.dto.ActivityDataDto;
import com.bxm.adsprod.service.activity.RandomUtils;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Deprecated
@Service(version="1.0.0")
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Value(value="${activity.db}")
    private int activityDb;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private JedisPool jedisPool;

    public InfoActivity getActMsg(String actId) {
        try {
            KeyGenerator actKey = ActivityKeyGenerator.Filter.getActBasicMsg();
            InfoActivity result = (InfoActivity)this.fetcher.hfetchWithSelector(actKey, actId, InfoActivity.class, this.activityDb);
            if (result == null) {
                result = this.getDefaultActMsg();
            }
            return result;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5\u4fe1\u606fERROR", (Throwable)e);
            return null;
        }
    }

    public InfoActivity getDefaultActMsg() {
        try {
            KeyGenerator defaultKey = ActivityKeyGenerator.Filter.getActDefaultId();
            String defaultId = (String)this.fetcher.fetchWithSelector(defaultKey, String.class, this.activityDb);
            KeyGenerator actKey = ActivityKeyGenerator.Filter.getActBasicMsg();
            InfoActivity result = (InfoActivity)this.fetcher.hfetchWithSelector(actKey, defaultId, InfoActivity.class, this.activityDb);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Integer, Integer> getBakActMsg() {
        return this.getBizActMsg("DEFAULT");
    }

    public Map<Integer, Integer> getBizActMsg(String positionId) {
        try {
            KeyGenerator actKey = ActivityKeyGenerator.Filter.getActRandomMsg((String)positionId);
            Map actWeightMap = (Map)this.fetcher.fetchWithSelector(actKey, Map.class, this.activityDb);
            if (null == actWeightMap || actWeightMap.keySet().size() == 0) {
                return this.getDefaultActConf();
            }
            return actWeightMap;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e7f\u544a\u4f4d\u6d3b\u52a8\u6e20\u9053\u4fe1\u606fERROR", (Throwable)e);
            return null;
        }
    }

    public List<WeightEntry> getPerClick(String positionId, String dafaultView, String defaultRepeatClicks, Map<Integer, Integer> activityIdFactor) {
        ArrayList entries = Lists.newArrayList();
        for (Integer activityId : activityIdFactor.keySet()) {
            entries.add(this.calWeight(activityId, positionId, NumberUtils.toInt((String)dafaultView), NumberUtils.toInt((String)defaultRepeatClicks), activityIdFactor.get(activityId)));
        }
        Collections.sort(entries);
        return entries;
    }

    private WeightEntry calWeight(Integer actId, String positionId, int dafaultView, int defaultRepeatClicks, Integer factor) {
        KeyGenerator countAct24H;
        KeyGenerator countAct2H = ActivityKeyGenerator.Filter.getCountAct2H((Integer)actId);
        ActivityDataDto data = (ActivityDataDto)this.fetcher.hfetchWithSelector(countAct2H, positionId, ActivityDataDto.class, this.activityDb);
        if (!(data != null && data.getRepeatCoupons(Integer.valueOf(dafaultView)) != null || (data = (ActivityDataDto)this.fetcher.hfetchWithSelector(countAct24H = ActivityKeyGenerator.Filter.getCountAct24H((Integer)actId), positionId, ActivityDataDto.class, this.activityDb)) != null && data.getRepeatCoupons(Integer.valueOf(dafaultView)) != null)) {
            KeyGenerator countActAllUv = ActivityKeyGenerator.Filter.getCountActAllUv((Integer)actId, (String)positionId);
            KeyGenerator countActAllClick = ActivityKeyGenerator.Filter.getCountActAllClick((Integer)actId, (String)positionId);
            Integer uv = this.pfCountWithSelector(countActAllUv.generateKey());
            Integer click = (Integer)this.fetcher.fetchWithSelector(countActAllClick, Integer.class, this.activityDb);
            data = new ActivityDataDto();
            data.setUv(uv != null ? uv : 0);
            data.setClicks(click != null ? click : 0);
        }
        int repeatClicks = data != null && data.getRepeatCoupons(Integer.valueOf(dafaultView)) != null ? data.getRepeatCoupons() : defaultRepeatClicks;
        return new WeightEntry(actId, repeatClicks, factor);
    }

    public List<WeightEntry> getPerClick(String positionId, Map<Integer, Integer> activityIdFactor) {
        KeyGenerator defaultNumKey = ActivityKeyGenerator.Filter.getActDefaultNum();
        String dafaultView = (String)this.fetcher.fetchWithSelector(defaultNumKey, String.class, this.activityDb);
        dafaultView = StringUtils.isNotBlank((CharSequence)dafaultView) ? dafaultView : "100";
        KeyGenerator defaultRepeatKey = ActivityKeyGenerator.Filter.getActDefaultRepeat();
        String defaultRepeatClicks = (String)this.fetcher.fetchWithSelector(defaultRepeatKey, String.class, this.activityDb);
        defaultRepeatClicks = StringUtils.isNotBlank((CharSequence)defaultRepeatClicks) ? defaultRepeatClicks : "200";
        return this.getPerClick(positionId, dafaultView, defaultRepeatClicks, activityIdFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer pfCountWithSelector(String redisKey) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.select(this.activityDb);
            Long value = jedis.pfcount(redisKey);
            Integer n = value.intValue();
            return n;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public Map<Integer, Integer> getDefaultActConf() {
        try {
            KeyGenerator actKey = ActivityKeyGenerator.Filter.getActDefaultMsg();
            Map actWeightMap = (Map)this.fetcher.fetchWithSelector(actKey, Map.class, this.activityDb);
            return actWeightMap;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9ed8\u8ba4\u5e7f\u544a\u4f4d\u6d3b\u52a8\u6e20\u9053\u4fe1\u606fERROR", (Throwable)e);
            return null;
        }
    }

    public InfoActivity getActivity(String uid, String positionId) {
        try {
            Integer actId;
            Map<Integer, Integer> actWeightMap = this.getBizActMsg(positionId);
            if (actWeightMap == null) {
                actWeightMap = this.getBakActMsg();
            }
            Set<Integer> actIds = this.userService.getUserActRecord(uid);
            actWeightMap.keySet().removeAll(actIds);
            if (actWeightMap.keySet().size() == 0) {
                actWeightMap = this.getBakActMsg();
            }
            if ((actId = RandomUtils.getKeyByRate(actWeightMap)) == -1) {
                throw new Exception("Illegal activity rate");
            }
            InfoActivity result = this.getActMsg(actId.toString());
            if (result == null) {
                throw new Exception("Illegal activity");
            }
            this.updateUserActRecord(actIds, actWeightMap, actId, uid);
            return result;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d3b\u52a8\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            return this.getDefaultActMsg();
        }
    }

    public void updateUserActRecord(Set<Integer> actIds, Map<Integer, Integer> actWeightMap, Integer actId, String uid) {
        if (actWeightMap.keySet().size() == 1) {
            this.userService.saveUserActRecord(uid, Sets.newHashSet());
        } else {
            actIds.add(actId);
            this.userService.saveUserActRecord(uid, actIds);
        }
    }
}

