/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.advertiser;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.advertiser.Advertiser;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.service.ticket.event.BalanceChangedEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EventObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class AdvertiserServiceImpl
implements AdvertiserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcherForOld0")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Autowired
    private EventPark eventPark;
    @Autowired
    private TicketStatisticsService ticketStatisticsService;

    public Long getAdvertiserBalance(BigInteger advertiserId) {
        return this.getAdvertiserBalance0(advertiserId);
    }

    public Long incrementBalance(BigInteger advertiserId, Long incValue) {
        Preconditions.checkNotNull((Object)advertiserId);
        Preconditions.checkNotNull((Object)incValue);
        Long balance = this.getAdvertiserBalance0(advertiserId);
        long finalValue = incValue + balance;
        this.eventPark.post((EventObject)new BalanceChangedEvent(this, advertiserId, incValue, finalValue));
        return finalValue;
    }

    private KeyGenerator getKeyGenerator() {
        return TicketKeyGenerator.Advertiser.getBalance();
    }

    private Long getAdvertiserBalance0(final BigInteger advertiserId) {
        Advertiser advertiser = (Advertiser)this.fetcher.fetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"advertiser", "adshop", advertiserId});
            }
        }, null, Advertiser.class);
        if (null == advertiser) {
            return 0L;
        }
        BigDecimal balance = advertiser.getBalance();
        if (null == balance) {
            return 0L;
        }
        BigDecimal budget = new BigDecimal(0);
        String certificateIds = advertiser.getCertificateIds();
        if (StringUtils.isNotBlank((String)certificateIds)) {
            String[] ids;
            for (String id : ids = StringUtils.split((String)certificateIds, (char)',')) {
                long budgetOfToday = this.ticketStatisticsService.getBudgetOfToday(TypeHelper.castToBigInteger((Object)id));
                budget = budget.add(new BigDecimal(budgetOfToday));
            }
        }
        balance = balance.subtract(this.getAdvertiserFreeze(advertiserId)).multiply(new BigDecimal(1000));
        return balance.subtract(budget).longValue();
    }

    private BigDecimal getAdvertiserFreeze(BigInteger advertiserId) {
        BigDecimal v = (BigDecimal)this.fetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"advertiser", "adshop_freeze", advertiserId}), BigDecimal.class);
        return null != v ? v : new BigDecimal(0);
    }
}

