/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.award.impl;

import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.award.Award;
import com.bxm.adsprod.facade.award.AwardDto;
import com.bxm.adsprod.facade.award.AwardService;
import com.bxm.adsprod.facade.award.FetchAwardDto;
import com.bxm.adsprod.facade.award.UserAwardDto;
import com.bxm.adsprod.facade.award.UserAwardVo;
import com.bxm.adsprod.integration.activity.ActivitiesService;
import com.bxm.adsprod.model.dao.award.UserWinLog;
import com.bxm.adsprod.model.dao.ticket.UserTicketLog;
import com.bxm.adsprod.service.award.EntiryAwardService;
import com.bxm.adsprod.service.award.TicketAwardService;
import com.bxm.adsprod.service.award.UserTicketLogService;
import com.bxm.adsprod.service.award.UserWinLogService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", owner="kk.xie")
public class AwardServiceImpl
implements AwardService {
    private Logger logger = LoggerFactory.getLogger(AwardServiceImpl.class);
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired
    private EntiryAwardService entiryAwardService;
    @Autowired
    private TicketAwardService ticketAwardService;
    @Autowired
    private UserWinLogService userWinLogService;
    @Autowired
    private UserTicketLogService userTicketLogService;
    private static final ExecutorService USER_TICKET_LOG_POOL = new ThreadPoolExecutor(100, 300, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("userTicketLog"));

    public Award get(AwardDto awardDto) {
        Award result = new Award();
        int times = this.activitiesService.findUserJoinTimes(awardDto.getUid(), awardDto.getPositionId(), String.valueOf(awardDto.getActivityid()));
        if (times <= 0) {
            result.setIscontinue(Boolean.valueOf(false));
            return result;
        }
        result = this.entiryAwardService.get(awardDto);
        if (result == null) {
            result = this.ticketAwardService.get(awardDto);
        }
        this.insertUserTicketLog(result, awardDto);
        return result;
    }

    private void insertUserTicketLog(Award result, AwardDto awardDto) {
        USER_TICKET_LOG_POOL.submit(() -> {
            try {
                if (result != null) {
                    UserTicketLog userTicketLog = this.getUserTicketLog(awardDto, result);
                    this.userTicketLogService.insertSelective(userTicketLog);
                }
            }
            catch (Exception e) {
                this.logger.error("insert user ticket log error", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetch(FetchAwardDto fetchAwardDto) {
        UserWinLog userWinLog;
        Integer state;
        block8: {
            String orderNum = fetchAwardDto.getOrdernum();
            state = fetchAwardDto.getState();
            if (StringUtils.isEmpty((CharSequence)orderNum) || state == null) {
                return false;
            }
            userWinLog = this.userWinLogService.selectByOrderNum(orderNum);
            if (userWinLog != null) break block8;
            boolean bl = false;
            return bl;
        }
        try {
            if (state != 2) {
                userWinLog.setUsername(fetchAwardDto.getUsername());
                userWinLog.setPhone(fetchAwardDto.getPhone());
                userWinLog.setUseraddress(fetchAwardDto.getUseraddress());
                this.userWinLogService.updateByPrimaryKeySelective(userWinLog);
            } else {
                userWinLog.setState(Integer.valueOf(2));
                this.userWinLogService.updateByPrimaryKeySelective(userWinLog);
            }
        }
        catch (Exception e) {
            this.logger.error("AwardService.fetch error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public List<UserAwardVo> fetchUserAward(UserAwardDto userAwardDto) {
        List<UserTicketLog> userTicketLogList = this.userTicketLogService.selectByUidPositionActivity(userAwardDto.getUid(), userAwardDto.getPositionId(), userAwardDto.getActivityid());
        return this.getUserAwardVoList(userTicketLogList);
    }

    private List<UserAwardVo> getUserAwardVoList(List<UserTicketLog> userTicketLogList) {
        ArrayList userAwardVoList = Lists.newArrayList();
        for (UserTicketLog userTicketLog : userTicketLogList) {
            UserAwardVo userAwardVo = new UserAwardVo();
            BeanUtils.copyProperties((Object)userTicketLog, (Object)userAwardVo);
            userAwardVoList.add(userAwardVo);
        }
        return userAwardVoList;
    }

    private UserTicketLog getUserTicketLog(AwardDto awardDto, Award result) {
        UserTicketLog userTicketLog = new UserTicketLog();
        userTicketLog.setActivityId(Long.valueOf(awardDto.getActivityid().longValue()));
        userTicketLog.setAssetId(result.getAssetsId());
        userTicketLog.setAssetImg(result.getAwardimg());
        userTicketLog.setAssetIntro(result.getAwardmsg());
        userTicketLog.setAssetName(result.getAwardname());
        userTicketLog.setIpaddress(awardDto.getIpaddress());
        userTicketLog.setPositionid(awardDto.getPositionId());
        userTicketLog.setTicketId(result.getAwardid());
        userTicketLog.setTicketLink(result.getAwardlink());
        userTicketLog.setUid(awardDto.getUid());
        return userTicketLog;
    }
}

