/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.award.impl;

import com.bxm.activites.facade.model.ActivityAwardRelationDto;
import com.bxm.activites.facade.model.InfoActivity;
import com.bxm.adsprod.facade.award.Award;
import com.bxm.adsprod.facade.award.AwardDto;
import com.bxm.adsprod.integration.activity.ActivitiesService;
import com.bxm.adsprod.model.dao.award.UserWinLog;
import com.bxm.adsprod.service.award.EntiryAwardService;
import com.bxm.adsprod.service.award.UserWinLogService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EntiryAwardServiceImpl
implements EntiryAwardService {
    @Value(value="${activity.db}")
    private int activityDb;
    private Logger logger = LoggerFactory.getLogger(EntiryAwardServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired
    private UserWinLogService userWinLogService;

    @Override
    public Award get(AwardDto awardDto) {
        Award result = null;
        try {
            Map<Long, String> awardMap;
            Long awardId;
            Integer acticityId = awardDto.getActivityid();
            List<ActivityAwardRelationDto> awards = this.getAwardsListByActId(String.valueOf(acticityId));
            if (CollectionUtils.isNotEmpty(awards) && (awardId = this.getLotteryLevel(awardMap = this.getAwardMap(awards), 100000)) != -1L) {
                ActivityAwardRelationDto activityAwardRelationDto = this.getAwardByAwardId(awards, awardId);
                result = this.getAward(activityAwardRelationDto);
                Boolean isSuccess = this.activitiesService.subAwardAmount(Long.valueOf(acticityId.intValue()), awardId);
                if (isSuccess.booleanValue()) {
                    InfoActivity activity = this.activitiesService.getActMsg(String.valueOf(acticityId));
                    UserWinLog userWinLog = this.getUserWinLog(awardDto, activityAwardRelationDto, activity);
                    String orderNum = this.userWinLogService.insert(userWinLog);
                    result.setOrdernum(orderNum);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("EntiryAwardService.get error", (Throwable)e);
            return null;
        }
        return result;
    }

    private UserWinLog getUserWinLog(AwardDto awardInfoDto, ActivityAwardRelationDto award, InfoActivity activity) {
        UserWinLog userWinLog = new UserWinLog();
        userWinLog.setToken(awardInfoDto.getUid());
        userWinLog.setAppkey(awardInfoDto.getAppkey());
        userWinLog.setIpaddress(awardInfoDto.getIpaddress());
        userWinLog.setPrizesid(award.getAwardId());
        userWinLog.setPrizesname(award.getAwardName());
        userWinLog.setActivityid(activity.getActivityid());
        userWinLog.setActivityname(activity.getActivityname());
        userWinLog.setPrizesimg(award.getAwardImg());
        return userWinLog;
    }

    private Award getAward(ActivityAwardRelationDto activityAwardRelationDto) {
        Award result = new Award();
        result.setAwardid(activityAwardRelationDto.getId());
        result.setAwardtype(Integer.valueOf(1));
        result.setAwardimg(activityAwardRelationDto.getAwardImg());
        result.setAwardlink("");
        result.setAwardname(activityAwardRelationDto.getAwardName());
        result.setButtontext("");
        result.setValiditytime("");
        return result;
    }

    private ActivityAwardRelationDto getAwardByAwardId(List<ActivityAwardRelationDto> awards, Long awardId) {
        for (ActivityAwardRelationDto award : awards) {
            if (!awardId.equals(award.getAwardId())) continue;
            return award;
        }
        return new ActivityAwardRelationDto();
    }

    private Long getLotteryLevel(Map<Long, String> map, Integer total) {
        Integer randNum;
        Random random = new Random(System.nanoTime());
        if (total == 0) {
            total = 1;
        }
        if ((randNum = Integer.valueOf(Math.abs(random.nextInt()) % total)) == 0) {
            randNum = 1;
        }
        for (Map.Entry<Long, String> it : map.entrySet()) {
            String[] str = it.getValue().split("-");
            Integer start = Integer.valueOf(str[0]);
            Integer end = Integer.valueOf(str[1]);
            if (randNum < start || randNum > end) continue;
            return it.getKey();
        }
        return -1L;
    }

    private Map<Long, String> getAwardMap(List<ActivityAwardRelationDto> awards) {
        HashMap map = Maps.newHashMap();
        Integer sum = 0;
        for (ActivityAwardRelationDto infoActivityPrizeRelation : awards) {
            String rate = infoActivityPrizeRelation.getRate();
            int awardRate = NumberUtils.toInt((String)rate);
            map.put(Long.valueOf(infoActivityPrizeRelation.getAwardId()), sum + "-" + (awardRate + sum));
            sum = sum + awardRate;
        }
        map.put(-1L, sum + "-" + (100000 - sum));
        return map;
    }

    private List<ActivityAwardRelationDto> getAwardsListByActId(String activityid) {
        KeyGenerator awardKey = () -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "AWARD", "MSG", activityid});
        List awardList = this.fetcher.fetchListWithSelector(awardKey, ActivityAwardRelationDto.class, this.activityDb);
        return awardList;
    }
}

