/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.award.impl;

import com.bxm.adsprod.facade.award.Award;
import com.bxm.adsprod.facade.award.AwardDto;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.service.award.TicketAwardService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketAwardServiceImpl
implements TicketAwardService {
    Logger logger = LoggerFactory.getLogger(TicketAwardServiceImpl.class);
    @Autowired
    private TicketService ticketService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Award get(AwardDto awardInfoDto) {
        TicketRequest request = this.getTicketRequest(awardInfoDto);
        Ticket ticket = new Ticket();
        try {
            ticket = this.ticketService.get(request);
        }
        catch (Exception e) {
            this.logger.error("ticketService.get error", (Throwable)e);
        }
        return this.of(ticket);
    }

    private TicketRequest getTicketRequest(AwardDto awardInfoDto) {
        TicketRequest request = new TicketRequest();
        request.setActivity(String.valueOf(awardInfoDto.getActivityid()));
        request.setImei(awardInfoDto.getI());
        request.setIp(awardInfoDto.getIpaddress());
        request.setPlatform(NumberUtils.toInt((String)awardInfoDto.getDevice(), (int)0));
        request.setOs(NumberUtils.toInt((String)awardInfoDto.getAppos(), (int)4));
        request.setPosition(awardInfoDto.getPositionId());
        request.setUid(awardInfoDto.getUid());
        request.setApp(StringUtils.equals((String)"1", (String)String.valueOf(awardInfoDto.getUa())) ? 1 : (StringUtils.equals((String)"2", (String)String.valueOf(awardInfoDto.getUa())) ? 2 : 0));
        request.setScene(Integer.valueOf(StringUtils.equals((String)"1", (String)String.valueOf(awardInfoDto.getScene())) ? 1 : 0));
        return request;
    }

    private Award of(Ticket ticket) {
        if (null == ticket) {
            return null;
        }
        TicketAssets assets = ticket.getOfferAssets();
        if (null == assets) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("ad-ticket {} assets is null");
            }
            return null;
        }
        Award o = new Award();
        o.setAwardname(assets.getName());
        o.setAwardimg(assets.getImage());
        o.setAwardid(Long.valueOf(ticket.getId().longValue()));
        o.setAssetsId(Long.valueOf(assets.getId().longValue()));
        o.setAwardlink(ticket.getUrl());
        o.setAwardtype(Integer.valueOf(2));
        o.setShopstype(Integer.valueOf(NumberUtils.toInt((String)ticket.getDomainCode(), (int)-1)));
        o.setButtontext(assets.getButtonTxt());
        o.setAwardangle("300");
        o.setValiditytime(this.date2String(ticket.getValidEndDate()));
        o.setLandingType(ticket.isSupportedOs(5) ? 1 : 0);
        return o;
    }

    private String date2String(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }
}

