/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.commons.cached;

import com.bxm.adsprod.service.commons.cached.annotation.Caching;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CachedAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedAspect.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @AfterReturning(pointcut="@annotation(com.bxm.adsprod.service.commons.cached.annotation.Caching)", returning="returning")
    public void doAfterReturning(JoinPoint point, Object returning) {
        block7: {
            Object[] args = point.getArgs();
            Method method = this.getMethod(point);
            if (null == method) {
                return;
            }
            if (null == returning) {
                return;
            }
            final Caching annotation = method.getAnnotation(Caching.class);
            if (null == annotation) {
                return;
            }
            try {
                final String field = BeanUtils.getProperty((Object)returning, (String)annotation.keyFieldName());
                boolean hashModal = annotation.isHashModal();
                if (!hashModal) {
                    this.updater.update(new KeyGenerator(){

                        public String generateKey() {
                            return annotation.prefix() + field;
                        }
                    }, returning, annotation.expireTimesInSecond());
                } else {
                    this.updater.hupdate(new KeyGenerator(){

                        public String generateKey() {
                            return annotation.prefix();
                        }
                    }, field, returning, annotation.expireTimesInSecond());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("getMappedProperty: ", (Throwable)e);
            }
        }
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

