/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.commons.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="com.bxm.adsprod:type=TaskMetrics,name=consumeTime")
public class ConsumeTimeMetrics {
    private final ConcurrentMap<String, AtomicLong> lastTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, AtomicLong> largestTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicLong>();

    public void increaseTask(String serviceName, long consumingTime) {
        AtomicLong lastTaskConsumeTime = this.lastTaskConsumeTimeTable.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == lastTaskConsumeTime) {
            lastTaskConsumeTime = (AtomicLong)this.lastTaskConsumeTimeTable.get(serviceName);
        }
        lastTaskConsumeTime.set(consumingTime);
        AtomicLong largestTimeContainer = this.largestTaskConsumeTimeTable.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == largestTimeContainer) {
            largestTimeContainer = (AtomicLong)this.largestTaskConsumeTimeTable.get(serviceName);
        }
        this.processLargestTaskConsumeTime(largestTimeContainer, consumingTime);
    }

    private void processLargestTaskConsumeTime(AtomicLong largestTimeContainer, long consumingTime) {
        int retry = 0;
        boolean done = false;
        do {
            long expect;
            if (consumingTime <= (expect = largestTimeContainer.longValue())) continue;
            done = largestTimeContainer.compareAndSet(expect, consumingTime);
        } while (!done && ++retry < 3);
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getLastTaskConsumeTimeTable() {
        return this.lastTaskConsumeTimeTable;
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getLargestTaskConsumeTimeTable() {
        return this.largestTaskConsumeTimeTable;
    }
}

