/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.commons.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="com.bxm.adsprod:type=TaskMetrics,name=counter")
public class CounterMetrics {
    private final ConcurrentMap<String, AtomicLong> successTasks = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, AtomicLong> failTasks = new ConcurrentHashMap<String, AtomicLong>();

    public void incrementSuccessTask(String serviceName) {
        AtomicLong counter = this.successTasks.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == counter) {
            counter = (AtomicLong)this.successTasks.get(serviceName);
        }
        counter.incrementAndGet();
    }

    public void incrementFailTask(String serviceName) {
        AtomicLong counter = this.failTasks.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == counter) {
            counter = (AtomicLong)this.failTasks.get(serviceName);
        }
        counter.incrementAndGet();
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getSuccessTasks() {
        return this.successTasks;
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getFailTasks() {
        return this.failTasks;
    }
}

