/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.commons.metrics;

import com.bxm.adsprod.service.commons.metrics.ConsumeTimeMetrics;
import com.bxm.adsprod.service.commons.metrics.CounterMetrics;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-99)
@Aspect
@Component
public class MetricsAspect {
    @Autowired
    private ConsumeTimeMetrics consumeTimeMetrics;
    @Autowired
    private CounterMetrics counterMetrics;

    @Bean
    public ConsumeTimeMetrics consumeTimeMetrics() {
        return new ConsumeTimeMetrics();
    }

    @Bean
    public CounterMetrics counterMetrics() {
        return new CounterMetrics();
    }

    @Around(value="within(@com.alibaba.dubbo.config.annotation.Service *)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long start = System.currentTimeMillis();
        Object proceed = point.proceed();
        try {
            String name = this.getServiceName((JoinPoint)point);
            long consumingTime = System.currentTimeMillis() - start;
            this.consumeTimeMetrics.increaseTask(name, consumingTime);
            this.counterMetrics.incrementSuccessTask(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proceed;
    }

    @AfterThrowing(value="within(@com.alibaba.dubbo.config.annotation.Service *))", throwing="throwing")
    public void afterThrowing(JoinPoint point, Throwable throwing) {
        this.counterMetrics.incrementFailTask(this.getServiceName(point));
    }

    private String getServiceName(JoinPoint point) {
        return point.getSignature().toShortString();
    }
}

