/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.media;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.so.rules.PositionGroupRuleSo;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigInteger;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class PositionGroupServiceImpl
implements PositionGroupService {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisCounter")
    protected Counter counter;

    public Map<String, Long> getBudgetOfToday(BigInteger ticketId) {
        return this.counter.hgetall(TicketKeyGenerator.Statistics.getBudgetOfPositionGroup((BigInteger)ticketId));
    }

    public long getBudgetOfToday(BigInteger ticketId, String groupId) {
        Long rst = this.counter.hget(TicketKeyGenerator.Statistics.getBudgetOfPositionGroup((BigInteger)ticketId), groupId);
        return null == rst ? 0L : rst;
    }

    public long incrementIfNecessary(BigInteger ticketId, String position, long incValue) {
        PositionGroupRuleSo.Entry config = (PositionGroupRuleSo.Entry)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionGroup((BigInteger)ticketId), position, PositionGroupRuleSo.Entry.class);
        if (null == config) {
            return 0L;
        }
        String groupId = config.getGroupId();
        return this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getBudgetOfPositionGroup((BigInteger)ticketId), groupId, incValue, this.getExpireTimeInSeconds().intValue());
    }

    public long increment(BigInteger ticketId, String groupId, long incValue) {
        return this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getBudgetOfPositionGroup((BigInteger)ticketId), groupId, incValue, this.getExpireTimeInSeconds().intValue());
    }

    private Integer getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfDay((int)10));
    }
}

