/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.ticket.OcpcOfferException;
import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.event.OcpcThresholdEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(version="1.0.0", owner="allen")
public class OcpcServiceImpl
implements OcpcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpcServiceImpl.class);
    public static final int DEFAULT_FLOOR_PRICE = 100;
    public static final long DEFAULT_CLOSE_THRESHOLD = 100L;
    public static final int DEFAULT_BOTTOM_PRICE = 10;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Autowired
    private EventPark eventPark;
    @Autowired
    private JedisPool jedisPool;

    public int offer(Ticket ticket, String position) {
        BigInteger ticketId = ticket.getId();
        if (null == ticketId) {
            throw new OcpcOfferException("ticketId is null");
        }
        long clickCount = this.incrementClick(ticketId, position);
        int floorPrice = NumberUtils.toInt((String)String.valueOf(ticket.getFloorPrice()), (int)100);
        int offer = this.getFirstOffer(ticket, position, true);
        long validClickCount = this.getValidClickCount(ticketId, position);
        long closeThreshold = NumberUtils.toLong((String)String.valueOf(ticket.getCloseThreshold()), (long)100L);
        if (validClickCount == 0L) {
            offer = floorPrice;
            if (clickCount > closeThreshold) {
                offer = 10;
            }
        }
        this.incrementConsume(ticketId, position, offer);
        return offer;
    }

    public void reset(BigInteger ticketId, String position) {
        if (!this.delOfferSheet(ticketId, position)) {
            throw new IllegalStateException("You cannot delete offset sheet, Cause it's was creating now.");
        }
        this.resetClick(ticketId, position);
        this.removeToClosePool(ticketId, position);
    }

    public boolean isUnderFloorPrice(Ticket ticket, String position) {
        int offer = this.getFirstOffer(ticket, position, false);
        return offer < ticket.getFloorPrice();
    }

    private int calculate(int cpaPrice, int cpcPrice, long consume, long validClickCount) {
        return new BigDecimal(cpaPrice).multiply(new BigDecimal(validClickCount)).divide(new BigDecimal(consume), 3, 4).multiply(new BigDecimal(cpcPrice)).intValue();
    }

    public void doValidClick(Ticket ticket, String position, long consume, long validClickCount) {
        this.incrementValidClickCount(ticket.getId(), position);
        this.createOfferSheet(ticket, position, consume, validClickCount);
    }

    public void doCloseIfNeeded(Ticket ticket, String position, long consume, long validClickCount) {
        boolean isNeededClose;
        this.resetValidClickCount(ticket.getId(), position, validClickCount);
        Integer cpaPrice = ticket.getCpaPrice();
        Integer cpcPrice = ticket.getPrice();
        Integer floorPrice = ticket.getFloorPrice();
        int offerNext = consume > 0L ? this.calculate(cpaPrice, cpcPrice, consume, validClickCount) : floorPrice.intValue();
        long clickCount = this.getClick(ticket.getId(), position);
        boolean bl = isNeededClose = offerNext < floorPrice && clickCount >= (long)ticket.getCloseThreshold().intValue();
        if (isNeededClose && LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}, {}] Offer price {}*{}/{}*{}={} was already under by floor price: {}", new Object[]{position, ticket.getId(), cpaPrice, validClickCount, consume, cpcPrice, offerNext, floorPrice});
        }
        this.eventPark.post((EventObject)new OcpcThresholdEvent(this, isNeededClose, position, ticket));
    }

    public void doClick(Ticket ticket, String position) {
        boolean isNeedClose;
        BigInteger ticketId = ticket.getId();
        long clickCount = this.incrementClick(ticketId, position);
        long validClickCount = this.getValidClickCount(ticketId, position);
        Integer closeThreshold = ticket.getCloseThreshold();
        boolean bl = isNeedClose = null != closeThreshold && clickCount >= (long)closeThreshold.intValue() && validClickCount == 0L;
        if (isNeedClose) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[{}, {}] It's doing close. click count={}, valid click count={}", new Object[]{position, ticket.getId(), clickCount, validClickCount});
            }
            this.eventPark.post((EventObject)new OcpcThresholdEvent(this, true, position, ticket));
        }
    }

    public void addToClosePool(BigInteger ticketId, String position) {
        if (null == ticketId) {
            return;
        }
        if (StringUtils.isBlank((String)position)) {
            return;
        }
        Set<String> closeSet = this.fetchClosed(position);
        closeSet.add(String.valueOf(ticketId));
        this.updater.update(TicketKeyGenerator.Ocpc.getClosed((String)position), closeSet);
    }

    public void removeToClosePool(BigInteger ticketId, String position) {
        if (null == ticketId) {
            return;
        }
        if (StringUtils.isBlank((String)position)) {
            return;
        }
        Set<String> closeSet = this.fetchClosed(position);
        closeSet.remove(String.valueOf(ticketId));
        this.updater.update(TicketKeyGenerator.Ocpc.getClosed((String)position), closeSet);
    }

    public boolean isClosed(BigInteger ticketId, String position) {
        if (null == ticketId) {
            return false;
        }
        if (StringUtils.isBlank((String)position)) {
            return false;
        }
        Set<String> closeSet = this.fetchClosed(position);
        return CollectionUtils.isNotEmpty(closeSet) && closeSet.contains(String.valueOf(ticketId));
    }

    public int getFloorPrice(int defaultValue) {
        Integer value = (Integer)this.fetcher.fetch(TicketKeyGenerator.Ocpc.getFloor(), null, Integer.class);
        return null == value ? defaultValue : value;
    }

    public int getFloorPrice() {
        Integer value = (Integer)this.fetcher.fetch(TicketKeyGenerator.Ocpc.getFloor(), null, Integer.class);
        return null == value ? 100 : value;
    }

    private Set<String> fetchClosed(String position) {
        Set closeSet = (Set)this.fetcher.fetch(TicketKeyGenerator.Ocpc.getClosed((String)position), null, Set.class);
        if (CollectionUtils.isEmpty((Collection)closeSet)) {
            closeSet = Sets.newHashSet();
        }
        return closeSet;
    }

    private void incrementConsume(BigInteger ticketId, String position, long incValue) {
        this.counter.hincrementByAndGet(TicketKeyGenerator.Ocpc.getConsume((BigInteger)ticketId), position, incValue);
    }

    private long incrementValidClickCount(BigInteger ticketId, String position) {
        return this.counter.incrementAndGet(TicketKeyGenerator.Ocpc.getValidClick((BigInteger)ticketId, (String)position));
    }

    @Deprecated
    private void resetValidClickCount(BigInteger ticketId, String position, long value) {
        this.updater.update(TicketKeyGenerator.Ocpc.getValidClick((BigInteger)ticketId, (String)position), (Object)value, 86400);
    }

    private long getValidClickCount(BigInteger ticketId, String position) {
        Long value = (Long)this.fetcher.fetch(TicketKeyGenerator.Ocpc.getValidClick((BigInteger)ticketId, (String)position), Long.class);
        return null == value ? 0L : value;
    }

    private long getClick(BigInteger ticketId, String position) {
        Long value = (Long)this.fetcher.hfetch(TicketKeyGenerator.Ocpc.getClick((BigInteger)ticketId), position, Long.class);
        return null == value ? 0L : value;
    }

    private long incrementClick(BigInteger ticketId, String position) {
        return this.counter.hincrementByAndGet(TicketKeyGenerator.Ocpc.getClick((BigInteger)ticketId), position, 1L);
    }

    private void resetClick(BigInteger ticketId, String position) {
        this.updater.hupdate(TicketKeyGenerator.Ocpc.getClick((BigInteger)ticketId), position, (Object)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFirstOffer(Ticket ticket, String position, boolean pop) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            BigInteger ticketId = ticket.getId();
            String key = this.getOfferSheetKey(position, ticketId);
            String lockKey = this.getOfferSheetLockKey(position, ticketId);
            if (jedis.exists(lockKey).booleanValue()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[{}] [{}] It's creating offer sheet now, So return this floor price.", (Object)ticketId, (Object)position);
                }
                int n = 10;
                return n;
            }
            String offer = pop ? jedis.lpop(key) : jedis.lindex(key, 0L);
            int n = NumberUtils.toInt((String)offer, (int)10);
            return n;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOfferSheet(Ticket ticket, String position, long consume, long validClickCount) {
        BigInteger ticketId = ticket.getId();
        Integer cpaPrice = ticket.getCpaPrice();
        Integer cpcPrice = ticket.getPrice();
        String lockKey = this.getOfferSheetLockKey(position, ticketId);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (!this.tryLock(jedis, lockKey)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[{}] [{}] was already creating offer sheet.", (Object)ticketId, (Object)position);
                }
                return;
            }
            long startConsume = consume;
            String key = this.getOfferSheetKey(position, ticketId);
            jedis.del(key);
            ArrayList values = Lists.newArrayList();
            int offer = 10;
            int index = 1;
            do {
                if (consume > 0L && validClickCount > 0L) {
                    offer = this.calculate(cpaPrice, cpcPrice, consume, validClickCount);
                    int value = offer > cpcPrice ? 1 : 5;
                    int cpcDoublePrice = cpcPrice * 2;
                    offer = offer > cpcDoublePrice ? cpcDoublePrice : offer;
                    offer -= value * index;
                    ++index;
                }
                consume += (long)offer;
                values.add(String.valueOf(offer));
            } while (offer > 10);
            if (CollectionUtils.isNotEmpty((Collection)values)) {
                jedis.rpush(key, values.toArray(new String[0]));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[{}] [{}] was creating offer sheet range, initial consume is {}, valid click count is {}, final consume is {}, result is {}", new Object[]{ticketId, position, startConsume, validClickCount, consume, StringUtils.join((Collection)values, (String)"->")});
                }
            }
        }
        finally {
            if (null != jedis) {
                this.unlock(jedis, lockKey);
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delOfferSheet(BigInteger ticketId, String position) {
        String lockKey = this.getOfferSheetLockKey(position, ticketId);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (!this.tryLock(jedis, lockKey)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[{}] [{}] was already creating offer sheet.", (Object)ticketId, (Object)position);
                }
                boolean bl = false;
                return bl;
            }
            String key = this.getOfferSheetKey(position, ticketId);
            jedis.del(key);
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != jedis) {
                this.unlock(jedis, lockKey);
                jedis.close();
            }
        }
    }

    private boolean tryLock(Jedis jedis, String lockKey) {
        return jedis.setnx(lockKey, String.valueOf(1)) == 1L;
    }

    private void unlock(Jedis jedis, String lockKey) {
        jedis.del(lockKey);
    }

    private String getOfferSheetKey(String position, BigInteger ticketId) {
        return TicketKeyGenerator.Ocpc.getOfferSheet((String)position, (BigInteger)ticketId).generateKey();
    }

    private String getOfferSheetLockKey(String position, BigInteger ticketId) {
        return TicketKeyGenerator.Ocpc.getOfferSheetLock((String)position, (BigInteger)ticketId).generateKey();
    }
}

