/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketAssetsService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.assets.TicketAssetsStatistics;
import com.bxm.warcar.cache.Fetcher;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TicketAssetsServiceImpl
implements TicketAssetsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketAssetsServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public List<TicketAssets> get(BigInteger ticketId) {
        if (null == ticketId) {
            return null;
        }
        return this.fetcher.hfetchList(TicketKeyGenerator.getTicketAssets(), String.valueOf(ticketId), null, TicketAssets.class);
    }

    public long getAllClicks(String positionId, BigInteger assetsId) {
        if (null == assetsId) {
            return 0L;
        }
        Long allClicks = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAllAssetsClick((String)positionId), assetsId.toString(), Long.class);
        return allClicks == null ? 0L : allClicks;
    }

    public long getAllValidClicks(String positionId, BigInteger assetsId) {
        if (null == assetsId) {
            return 0L;
        }
        Long allValidClicks = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAllAssetsValidClick((String)positionId), assetsId.toString(), Long.class);
        return allValidClicks == null ? 0L : allValidClicks;
    }

    public long getAllViews(String positionId, BigInteger assetsId) {
        if (null == assetsId) {
            return 0L;
        }
        Long allViews = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAllAssetsView((String)positionId), assetsId.toString(), Long.class);
        return allViews == null ? 0L : allViews;
    }

    public String[] getTicketAssets2Hour(String positionId, BigInteger assetsId) {
        String value = (String)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAssets2Hour((String)positionId), assetsId.toString(), String.class);
        String[] s = new String[3];
        if (StringUtils.isNotBlank((String)value)) {
            s = value.split("-");
        } else {
            s[0] = "0";
            s[1] = "0";
            s[2] = "0";
        }
        return s;
    }

    public String[] getTicketAssets24Hour(String positionId, BigInteger assetsId) {
        String value = (String)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAssets24Hour((String)positionId), assetsId.toString(), String.class);
        String[] s = new String[3];
        if (StringUtils.isNotBlank((String)value)) {
            s = value.split("-");
        } else {
            s[0] = "0";
            s[1] = "0";
            s[2] = "0";
        }
        return s;
    }

    public TicketAssetsStatistics getOfHours(String positionId, BigInteger assetsId, int hours) {
        if (hours != -1 && hours != 2 && hours != 24) {
            throw new IllegalArgumentException("'hours' must be -1/2/24");
        }
        if (hours == -1) {
            return new TicketAssetsStatistics(this.getAllViews(positionId, assetsId), this.getAllClicks(positionId, assetsId), 0L);
        }
        String value = hours == 2 ? (String)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAssets2Hour((String)positionId), assetsId.toString(), String.class) : (String)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketAssets24Hour((String)positionId), assetsId.toString(), String.class);
        Object[] values = StringUtils.split((String)value, (char)'-');
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("--\u5e7f\u544a\u4f4d{},\u7d20\u6750ID{},{}\u5c0f\u65f6\u6570\u636e:{}", new Object[]{positionId, assetsId.toString(), hours, values});
        }
        if (ArrayUtils.isEmpty((Object[])values) || values.length != 2) {
            return new TicketAssetsStatistics();
        }
        TicketAssetsStatistics statistics = new TicketAssetsStatistics();
        statistics.setViews(NumberUtils.toLong((String)values[0], (long)0L));
        statistics.setClicks(NumberUtils.toLong((String)values[1], (long)0L));
        statistics.setValidClicks(0L);
        return statistics;
    }

    public TicketAssets getTicketAssets(BigInteger ticketId, BigInteger assetsId) {
        if (null == ticketId || null == assetsId) {
            return null;
        }
        List list = this.fetcher.hfetchList(TicketKeyGenerator.getTicketAssets(), String.valueOf(ticketId), null, TicketAssets.class);
        HashMap<String, TicketAssets> map = new HashMap<String, TicketAssets>();
        for (TicketAssets ta : list) {
            map.put(ta.getId() + "", ta);
        }
        TicketAssets ticketAssets = (TicketAssets)map.get(assetsId + "");
        return ticketAssets;
    }
}

