/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.common.utils.OkHttpUtils;
import com.bxm.adsprod.dal.ticket.TickOutSideLogMapper;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketAssetsService;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketOutsideService;
import com.bxm.adsprod.model.dao.ticket.TickOutSideLog;
import com.bxm.adsprod.model.dao.ticket.TicketOutside;
import com.bxm.adsprod.model.dao.ticket.TicketOutsidePosition;
import com.bxm.adsprod.service.commons.TicketInterceptorInvocation;
import com.bxm.adsprod.service.commons.configure.OutsideConfigutation;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.adsprod.service.ticket.filter.TicketFilterInterceptorChainOutside;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.KeyBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@Service(version="1.0.0", owner="kk.xie")
@EnableConfigurationProperties(value={OutsideConfigutation.class})
public class TicketOutsideServiceImpl
implements TicketOutsideService {
    private Logger logger = LoggerFactory.getLogger(TicketOutsideServiceImpl.class);
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    @Qualifier(value="ipIpNetIpLibrary")
    private IpLibrary ipLibrary;
    @Autowired
    TicketFilterInterceptorChainOutside ticketFilterInterceptorChainOutside;
    @Autowired
    TickOutSideLogMapper tickOutSideLogMapper;
    @Autowired
    OutsideConfigutation outsideConfigutation;
    @Autowired
    TicketAssetsService ticketAssetsService;
    private static final ExecutorService HTTP_POOL = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("outside"));

    public String getTicketUrl(String assetId, String ip) {
        String message;
        TicketOutside ticketOutside;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("TicketOutsideService.getTicketUrl \u5f00\u59cb\u8c03\u7528\uff0c\u53c2\u6570\uff1aassetID:{},ip:{}", (Object)assetId, (Object)ip);
        }
        String countUrl = this.outsideConfigutation.getUrl();
        String redirectUrl = this.outsideConfigutation.getRedirectUrl();
        TicketOutsidePosition ticketOutsidePosition = (TicketOutsidePosition)this.jedisFetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "OUTSIDE", "DEFAULT", "POSITION"}), TicketOutsidePosition.class);
        if (ticketOutsidePosition == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("AD:TICKET:OUTSIDE:DEFAULT:POSITION redis value is null !");
            }
            ticketOutsidePosition = new TicketOutsidePosition();
            ticketOutsidePosition.setModeltype(Integer.valueOf(7));
            ticketOutsidePosition.setActivityid(new BigInteger("12651"));
            ticketOutsidePosition.setAppkey("fbca14bb5bb74d5a9b5fa165ad78a15a");
            ticketOutsidePosition.setAppos(Integer.valueOf(1));
            ticketOutsidePosition.setAwardtype(Integer.valueOf(7));
            ticketOutsidePosition.setBusiness("ad-1");
            ticketOutsidePosition.setUa(Integer.valueOf(0));
            ticketOutsidePosition.setUid("zheshiyigezhuanyongde1uid1wudong");
        }
        if ((ticketOutside = (TicketOutside)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "OUTSIDE"}), assetId, TicketOutside.class)) == null || StringUtils.isBlank((String)ticketOutside.getUrl()) || ticketOutside.getTicketId() == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u793c\u5238\u7d20\u6750ID\uff1a{} \u4fe1\u606f\u4e0d\u5b58\u5728redis \u4e2d\u6216\u4e0d\u5b8c\u6574\uff01", (Object)assetId);
            }
            return "http://m.cudaojia.com?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
        }
        List ticketAssetsList = this.ticketAssetsService.get(ticketOutside.getTicketId());
        if (CollectionUtils.isNotEmpty((Collection)ticketAssetsList)) {
            ArrayList<String> assetIds = new ArrayList<String>();
            for (TicketAssets ticketAssets : ticketAssetsList) {
                String asset = ticketAssets.getId() == null ? "" : ticketAssets.getId().toString();
                assetIds.add(asset);
                if (!assetId.equals(asset) || ticketAssets.isAvailable()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u793c\u5238\u7d20\u6750ID\uff1a{} \u4e0d\u662f\u5f00\u542f\u72b6\u6001\uff01", (Object)assetId);
                }
                return "http://m.cudaojia.com?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
            }
            if (!assetIds.contains(assetId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u793c\u5238\u7d20\u6750ID\uff1a{} \u4e0d\u5728\u793c\u5238{} \u5bf9\u5e94\u7684\u7d20\u6750\u5217\u8868\u4e2d", (Object)assetId, (Object)ticketOutside.getTicketId());
                }
                return "http://m.cudaojia.com?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u793c\u5238\u7d20\u6750ID\uff1a{} \u5bf9\u5e94\u7684\u7d20\u6750\u7f13\u5b58\u5217\u8868\u4e3a\u7a7a\uff01", (Object)assetId);
            }
            return "http://m.cudaojia.com?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
        }
        ticketOutsidePosition.setPreid(ticketOutside.getTicketId());
        ticketOutsidePosition.setAssetId(assetId);
        String resultUrl = ticketOutside.getUrl();
        IP clientIp = this.getIp(ip);
        TicketCache ticketCache = (TicketCache)this.jedisFetcher.hfetch(TicketKeyGenerator.getAvailableTickets(), ticketOutside.getTicketId().toString(), TicketCache.class);
        ArrayList<TicketCache> normals = new ArrayList<TicketCache>();
        if (ticketCache == null) {
            message = "redis \u4e2d\u672a\u67e5\u8be2\u5230 \u793c\u5238ID\uff1a" + ticketOutside.getTicketId().toString() + " \u7684\u4fe1\u606f\uff0cassetId:" + assetId + ",\u8bf7\u6c42IP\uff1a" + ip;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message);
            }
            resultUrl = "http://m.cudaojia.com?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
        } else {
            normals.add(ticketCache);
            message = this.doFilter(normals, ticketOutside, clientIp);
        }
        if (normals.size() > 0) {
            this.asyncSubmitCountInfo(countUrl, ticketOutsidePosition, ticketOutside);
            resultUrl = this.advertiserUrl(ticketOutside, ticketOutsidePosition, countUrl);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u7d20\u6750ID:{},\u793c\u5238ID\uff1a{},\u88ab\u8fc7\u6ee4\u4e86,", (Object)assetId, (Object)ticketOutside.getTicketId());
            }
            TickOutSideLog tickOutSideLog = new TickOutSideLog();
            tickOutSideLog.setAssetId(Long.valueOf(assetId));
            tickOutSideLog.setOutsideUrl(countUrl);
            tickOutSideLog.setReason(message);
            tickOutSideLog.setUrl(ticketOutside.getUrl());
            tickOutSideLog.setTicketId(Long.valueOf(ticketOutside.getTicketId().toString()));
            tickOutSideLog.setRequestIp(ip);
            this.tickOutSideLogMapper.insert(tickOutSideLog);
        }
        try {
            String encodeUrl = URLEncoder.encode(resultUrl, "utf-8");
            redirectUrl = redirectUrl.contains("?") ? redirectUrl + "&url=" + encodeUrl : redirectUrl + "?url=" + encodeUrl;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("url\u7f16\u7801\u51fa\u9519\u4e86", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8df3\u8f6c\u9875\u9875\u5730\u5740\uff1a{}", (Object)redirectUrl);
        }
        return redirectUrl;
    }

    private String doFilter(List<TicketCache> normals, TicketOutside ticketOutside, IP clientIp) {
        FilterRequestModel requestModel = new FilterRequestModel();
        requestModel.setTickets(normals);
        requestModel.setIprst(clientIp);
        TicketInterceptorInvocation invocation = new TicketInterceptorInvocation();
        invocation.setRequestModel(requestModel);
        this.ticketFilterInterceptorChainOutside.intercept((Invocation)invocation);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u5e38\u89c4\u5238\u5916\u6295\u903b\u8f91\u8fc7\u6ee4\u540e\u5269\u4f59\u793c\u5238 size : {} ", (Object)normals.size());
        }
        return this.convert2InfoMessage(requestModel.getFilterMessage());
    }

    private String convert2InfoMessage(Map<Object, List<String>> map) {
        if (null == map) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        Set<Map.Entry<Object, List<String>>> entries = map.entrySet();
        for (Map.Entry<Object, List<String>> entry : entries) {
            Object key = entry.getKey();
            List<String> value = entry.getValue();
            s.append(key.getClass().getSimpleName()).append(value.toString()).append("\n");
        }
        return s.toString();
    }

    private IP getIp(String ip) {
        IP iprst = this.ipLibrary.find(ip);
        if (null == iprst) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u65e0\u6cd5\u83b7\u53d6\u5230IP\uff1a{} \u7684\u533a\u57df\u4fe1\u606f", (Object)ip);
            }
            iprst = new IP("\u4e2d\u56fd", "\u4e2d\u56fd", "\u4e2d\u56fd");
        }
        return iprst;
    }

    private String advertiserUrl(TicketOutside ticketOutside, TicketOutsidePosition ticketOutsidePosition, String countUrl) {
        String url = ticketOutside.getUrl();
        String result = this.sendHttp(ticketOutsidePosition, 7, countUrl);
        String resultUrl = url;
        if (result != null && result.contains("data")) {
            JSONObject object = JSONObject.parseObject((String)result);
            String param = url.contains("?") ? "&bxm_id=" + object.getString("data") : "?bxm_id=" + object.getString("data");
            resultUrl = url + param;
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3:{} \u5931\u8d25,\u76f4\u63a5\u8fd4\u56de\u5e7f\u544a\u4e3b\u843d\u5730\u9875 {}", (Object)countUrl, (Object)url);
        }
        if (!resultUrl.startsWith("http")) {
            resultUrl = "http://" + resultUrl;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u6700\u7ec8\u5e7f\u544a\u4e3b\u843d\u5730\u9875\u5730\u5740\uff1a{}", (Object)resultUrl);
        }
        return resultUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncSubmitCountInfo(String url, TicketOutsidePosition ticketOutsidePosition, TicketOutside ticketOutside) {
        AtomicInteger index = new AtomicInteger(1);
        ArrayList<Future<Integer>> futureList = new ArrayList<Future<Integer>>();
        int rateMin = ticketOutside.getClickRateMin();
        int rateMax = ticketOutside.getClickRateMax();
        Random random = new Random();
        int rate = random.nextInt(rateMax) % (rateMax - rateMin + 1) + rateMin;
        double times = 100.0 / (double)rate;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u793c\u5238ID\uff1a{} \uff0c\u6982\u7387\u8303\u56f4\uff1a[{},{}],\u968f\u673a\u6982\u7387\uff1a{}, \u6a21\u62df\u66dd\u5149\u6b21\u6570{}", new Object[]{ticketOutsidePosition.getPreid(), rateMin, rateMax, rate, times});
        }
        for (int i = 0; i < (int)times; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u6a21\u62df\u66dd\u5149\uff0c\u793c\u5238ID:{},\u7b2c{}\u6b21", (Object)ticketOutsidePosition.getPreid(), (Object)(i + 1));
            }
            futureList.add(this.sendHttp(ticketOutsidePosition, 5, url, index));
            futureList.add(this.sendHttp(ticketOutsidePosition, 6, url, index));
        }
        double decimalPart = times - (double)((int)times);
        double randomDouble = random.nextDouble();
        if (decimalPart > randomDouble) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u968f\u673a\u6a21\u62df\u66dd\u5149\uff0c\u793c\u5238ID:{}\uff0c\u7b2c{}\u6b21", (Object)ticketOutsidePosition.getPreid(), (Object)((int)times + 1));
            }
            futureList.add(this.sendHttp(ticketOutsidePosition, 5, url, index));
            futureList.add(this.sendHttp(ticketOutsidePosition, 6, url, index));
        }
        for (Future future : futureList) {
            try {
                Integer count = (Integer)future.get();
                if (!this.logger.isDebugEnabled() || count.intValue() != futureList.size()) continue;
                this.logger.debug("\u793c\u5238ID:{},\u7d20\u6750ID\uff1a{},\u53d1\u9001\u8bf7\u6c42\uff1a{} \u6b21", new Object[]{ticketOutsidePosition.getPreid(), ticketOutsidePosition.getAssetId(), count});
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private String sendHttp(TicketOutsidePosition ticketOutsidePosition, int modeltype, String url) {
        try {
            JSONObject jsonObject;
            ticketOutsidePosition.setModeltype(Integer.valueOf(modeltype));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appkey", ticketOutsidePosition.getAppkey());
            params.put("business", ticketOutsidePosition.getBusiness());
            params.put("activityid", ticketOutsidePosition.getActivityid());
            params.put("uid", ticketOutsidePosition.getUid());
            params.put("modeltype", ticketOutsidePosition.getModeltype());
            params.put("appos", ticketOutsidePosition.getAppos());
            params.put("awardtype", ticketOutsidePosition.getAwardtype());
            params.put("ua", ticketOutsidePosition.getUa());
            params.put("preid", ticketOutsidePosition.getPreid());
            params.put("assetsId", ticketOutsidePosition.getAssetId());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\uff1a{},\u53c2\u6570\uff1a{}", (Object)url, params);
            }
            String resultBody = OkHttpUtils.get((String)url, params);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)resultBody);
            }
            if (!(jsonObject = JSONObject.parseObject((String)resultBody)).getBoolean("success").booleanValue()) {
                resultBody = this.tryAgainSendUrl(url, params);
            }
            return resultBody;
        }
        catch (Exception e) {
            this.logger.error("sendHttp COUNT ERROR", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryAgainSendUrl(String url, Map<String, Object> params) {
        String result = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u63a5\u53e3{}\u8c03\u5ea6\u5931\u8d25\uff01\u6b63\u5728\u91cd\u8bd5...", (Object)url);
            }
            for (int i = 0; i < 3; ++i) {
                JSONObject jsonObject;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u63a5\u53e3{}\u8c03\u5ea6\u5931\u8d25\uff01\u6b63\u5728\u91cd\u8bd5\u7b2c {} \u6b21...", (Object)url, (Object)(i + 1));
                }
                if (!(jsonObject = JSONObject.parseObject((String)(result = OkHttpUtils.get((String)url, params)))).getBoolean("success").booleanValue()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u63a5\u53e3{}\uff0c\u91cd\u8bd5\u6210\u529f\uff01", (Object)url);
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Future<Integer> sendHttp(TicketOutsidePosition ticketOutsidePosition, int modeltype, String url, AtomicInteger index) {
        Future<Integer> future = HTTP_POOL.submit(() -> {
            try {
                JSONObject jsonObject;
                ticketOutsidePosition.setModeltype(Integer.valueOf(modeltype));
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("appkey", ticketOutsidePosition.getAppkey());
                params.put("business", ticketOutsidePosition.getBusiness());
                params.put("activityid", ticketOutsidePosition.getActivityid());
                params.put("uid", ticketOutsidePosition.getUid());
                params.put("modeltype", ticketOutsidePosition.getModeltype());
                params.put("appos", ticketOutsidePosition.getAppos());
                params.put("awardtype", ticketOutsidePosition.getAwardtype());
                params.put("ua", ticketOutsidePosition.getUa());
                params.put("preid", ticketOutsidePosition.getPreid());
                params.put("assetsId", ticketOutsidePosition.getAssetId());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\uff1a{},\u53c2\u6570\uff1a{}", (Object)url, params);
                }
                String resultBody = OkHttpUtils.get((String)url, params);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)resultBody);
                }
                if (!(jsonObject = JSONObject.parseObject((String)resultBody)).getBoolean("success").booleanValue()) {
                    this.tryAgainSendUrl(url, params);
                }
                return index.getAndIncrement();
            }
            catch (Exception e) {
                this.logger.error("sendHttp COUNT ERROR", (Throwable)e);
                return index.getAndIncrement();
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpClientPost(String url, Map<String, Object> params) {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded;CharSet=gbk"));
            httpPost.setHeader((Header)new BasicHeader("UserAgent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
            httpPost.setHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
            httpPost.setHeader((Header)new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
            httpPost.setHeader((Header)new BasicHeader("Accept-Encoding", "gzip, deflate"));
            httpPost.setHeader((Header)new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
            httpPost.setHeader((Header)new BasicHeader("Connection", "keep-alive"));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(30000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse httpResp = httpClient.execute((HttpUriRequest)httpPost);
            String resultBody = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)resultBody);
            }
            String string = resultBody;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }
}

