/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.convert.ticket.TicketConvert;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.media.PositionOfRules;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.IllegalTicketException;
import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketAssetsService;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.adsprod.model.so.rules.PositionGroupRuleSo;
import com.bxm.adsprod.service.commons.TicketInterceptorInvocation;
import com.bxm.adsprod.service.media.PositionService;
import com.bxm.adsprod.service.ticket.decorator.DecoratorRequestModel;
import com.bxm.adsprod.service.ticket.decorator.TicketDecoratorInterceptorChain;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.adsprod.service.ticket.filter.TicketFilterInterceptorChain;
import com.bxm.adsprod.service.ticket.info.TicketFliterInformationInfo;
import com.bxm.adsprod.service.ticket.info.TicketFliterInformationService;
import com.bxm.adsprod.service.ticket.scene.SceneService;
import com.bxm.adsprod.service.ticket.scene.SceneServiceFactory;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.integration.message.annotation.Messaging;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class TicketServiceImpl
implements TicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private TicketFilterInterceptorChain ticketFilterInterceptorChain;
    @Autowired
    private TicketDecoratorInterceptorChain ticketDecoratorInterceptorChain;
    @Autowired
    private TicketAssetsService ticketAssetsService;
    @Autowired
    private PositionService positionService;
    @Autowired
    @Qualifier(value="ipIpNetIpLibrary")
    private IpLibrary ipLibrary;
    @Autowired
    private AdsmanagerService adsmanagerService;
    @Autowired
    private OcpcService ocpcService;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private TicketFliterInformationService ticketFliterInformationService;

    public Ticket get(TicketRequest ticketRequest) {
        String ip;
        IP iprst;
        TicketCache cache;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request={}", (Object)ticketRequest);
        }
        if (null == (cache = this.getTicket(ticketRequest, iprst = this.getIp(ip = ticketRequest.getIp())))) {
            return null;
        }
        Ticket ticket = this.get(cache.getId());
        if (null == ticket) {
            return null;
        }
        TicketAssets assets = this.doDecorate(ticketRequest.getPosition(), ticket, iprst, ticket.getId());
        if (null == assets) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Cannot fetch any assets for ticket: {}", (Object)ticket.getId());
            }
            return null;
        }
        ticket.setOfferAssets(assets);
        ticket.setTime(new Date());
        return ticket;
    }

    private TicketCache getTicket(TicketRequest ticketRequest, IP iprst) {
        Integer scene;
        SceneService sceneService;
        String positionId = ticketRequest.getPosition();
        PositionOfRules position = this.positionService.get(positionId);
        if (null == position) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u975e\u6cd5/\u65e0\u6548\u7684\u5e7f\u544a\u4f4d: {}", (Object)positionId);
            }
            position = new Position(positionId);
        }
        if (null == (sceneService = SceneServiceFactory.getSceneService(scene = ticketRequest.getScene()))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Unsupported scene type: {} or it's not register finished yet.");
            }
            return null;
        }
        List<TicketCache> tickets = sceneService.getTickets(ticketRequest);
        if (CollectionUtils.isEmpty(tickets)) {
            return null;
        }
        ArrayList normals = Lists.newArrayList();
        ArrayList standbys = Lists.newArrayList();
        for (TicketCache ticket : tickets) {
            if (ticket.isNormalType()) {
                normals.add(ticket);
                continue;
            }
            standbys.add(ticket);
        }
        FilterRequestModel filterRequestModel = this.doFilter(ticketRequest, normals, (Position)position, iprst);
        if (CollectionUtils.isEmpty((Collection)normals)) {
            if (CollectionUtils.isEmpty((Collection)standbys)) {
                return null;
            }
            int platform = ticketRequest.getPlatform();
            this.removeStandbysIfNotEquals(platform, standbys);
            if (CollectionUtils.isEmpty((Collection)standbys)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("No any standby ticket for the platform: {}", (Object)platform);
                }
                return null;
            }
            TicketCache standby = (TicketCache)standbys.get(RandomUtils.nextInt((int)standbys.size()));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Returning the standby {}, Request params: {}, Filter history: \n{}", new Object[]{standby.getId(), ticketRequest, this.convert2InfoMessage(filterRequestModel.getFilterMessage())});
            }
            return standby;
        }
        return sceneService.getBestOne(ticketRequest, normals);
    }

    private void removeStandbysIfNotEquals(int platform, List<TicketCache> standbys) {
        Iterator<TicketCache> iterator = standbys.iterator();
        while (iterator.hasNext()) {
            TicketCache standby = iterator.next();
            if (platform == 0 && standby.isSupportedOs(5)) {
                iterator.remove();
            }
            if (platform != 1 || standby.isSupportedOs(5)) continue;
            iterator.remove();
        }
    }

    private String convert2InfoMessage(Map<Object, List<String>> map) {
        if (null == map) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        Set<Map.Entry<Object, List<String>>> entries = map.entrySet();
        for (Map.Entry<Object, List<String>> entry : entries) {
            Object key = entry.getKey();
            List<String> value = entry.getValue();
            s.append(key.getClass().getSimpleName()).append(value.toString()).append("\n");
        }
        return s.toString();
    }

    @Messaging(topicFieldNameOfConfiguration="view")
    public Ticket view(ViewRequest viewRequest) {
        BigInteger ticketId = viewRequest.getTicketId();
        Ticket ticket = this.get(ticketId);
        if (null == ticket) {
            return null;
        }
        ticket.setTime(new Date());
        return ticket;
    }

    @Messaging(topicFieldNameOfConfiguration="click")
    public Ticket click(ClickRequest clickRequest) {
        BigInteger ticketId = clickRequest.getTicketId();
        String position = clickRequest.getPosition();
        Ticket ticket = this.get(ticketId);
        if (null == ticket) {
            throw new IllegalTicketException("Ticket does not exists!");
        }
        ticket.setFloorPrice(Integer.valueOf(this.ocpcService.getFloorPrice()));
        int offerPrice = this.getOfferPrice(position, ticket);
        ticket.setOfferPrice(Integer.valueOf(offerPrice));
        if (!clickRequest.isValid() && ticket.isOcpc()) {
            int offer = this.ocpcService.offer(ticket, position);
            ticket.setOfferPrice(Integer.valueOf(offer));
        }
        ticket.setTime(new Date());
        ticket.setBillid(this.idGenerator.next());
        return ticket;
    }

    private int getOfferPrice(String position, Ticket ticket) {
        KeyGenerator keyGenerator = TicketKeyGenerator.Filter.getPositionGroup((BigInteger)ticket.getId());
        PositionGroupRuleSo.Entry config = (PositionGroupRuleSo.Entry)this.fetcher.hfetch(keyGenerator, position, PositionGroupRuleSo.Entry.class);
        Long positionPrice = null;
        if (null != config) {
            positionPrice = config.getPrice();
        }
        return positionPrice == null ? ticket.getPrice().intValue() : positionPrice.intValue();
    }

    public Ticket get(BigInteger ticketId) {
        return (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), null, Ticket.class);
    }

    public List<Ticket> getAllTickets() {
        return this.getAllTicketsForList();
    }

    public boolean updateTicketStatus(BigInteger ticketId, byte status, int reason) {
        Ticket ticket = this.get(ticketId);
        if (null == ticket) {
            throw new IllegalTicketException("Ticket " + ticketId + " does not exists!");
        }
        ticket.setStatus(Byte.valueOf(status));
        ticket.setPauseReason(Integer.valueOf(reason));
        this.updater.hupdate(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), (Object)ticket);
        if (status != 1) {
            this.updater.hremove(TicketKeyGenerator.getAvailableTickets(), new String[]{String.valueOf(ticketId)});
        } else {
            this.updater.hupdate(TicketKeyGenerator.getAvailableTickets(), String.valueOf(ticketId), (Object)TicketConvert.convert2TicketCache((Ticket)ticket));
        }
        boolean isSuccess = this.adsmanagerService.updateAdTicket(ticketId, status, reason);
        if (!isSuccess && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Ticket status was updated to adsmanager fail! ticketid={}, status={}, reason={}", new Object[]{ticketId, status, reason});
        }
        return isSuccess;
    }

    public void updateTicketGroupId(BigInteger ticketId, Long groupId) {
        TicketCache ticketCache;
        if (null == ticketId) {
            return;
        }
        Ticket ticket = (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), Ticket.class);
        if (null != ticket) {
            ticket.setGroupId(groupId);
            this.updater.hupdate(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), (Object)ticket);
        }
        if (null != (ticketCache = (TicketCache)this.fetcher.hfetch(TicketKeyGenerator.getAvailableTickets(), String.valueOf(ticketId), TicketCache.class))) {
            ticketCache.setGroupId(groupId);
            this.updater.hupdate(TicketKeyGenerator.getAvailableTickets(), String.valueOf(ticketId), (Object)ticketCache);
        }
    }

    private FilterRequestModel doFilter(TicketRequest ticketRequest, List<TicketCache> normals, Position position, IP iprst) {
        FilterRequestModel requestModel = new FilterRequestModel();
        requestModel.setTickets(normals);
        requestModel.setUid(ticketRequest.getUid());
        requestModel.setImei(ticketRequest.getImei());
        requestModel.setPlatform(ticketRequest.getPlatform());
        requestModel.setOs(ticketRequest.getOs());
        requestModel.setIp(ticketRequest.getIp());
        requestModel.setApp(ticketRequest.getApp());
        requestModel.setIprst(iprst);
        requestModel.setPosition(position);
        int size = normals.size();
        TicketInterceptorInvocation invocation = new TicketInterceptorInvocation();
        invocation.setRequestModel(requestModel);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u5bf9\u5e38\u89c4\u5e7f\u544a\u5238\u8fdb\u884c\u89c4\u5219\u8fc7\u6ee4\uff0c\u5171 {} \u5f20\u3002", (Object)normals.size());
        }
        this.ticketFilterInterceptorChain.intercept((Invocation)invocation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5e38\u89c4\u5e7f\u544a\u5238\u8fc7\u6ee4\u5b8c\u6210\uff0c\u4e00\u5171 {} \u5f20\uff0c\u8fc7\u6ee4\u540e {} \u5f20\u3002", (Object)size, (Object)normals.size());
        }
        TicketFliterInformationInfo ticketFliterInformationInfo = new TicketFliterInformationInfo(requestModel, position, normals);
        this.ticketFliterInformationService.getTicketFliterInformation(ticketFliterInformationInfo);
        return requestModel;
    }

    private TicketAssets doDecorate(String positionId, Ticket ticket, IP iprst, BigInteger ticketId) {
        List assets = this.ticketAssetsService.get(ticketId);
        if (CollectionUtils.isEmpty((Collection)assets)) {
            return null;
        }
        ticket.setAssets(assets);
        DecoratorRequestModel decoratorRequestModel = new DecoratorRequestModel();
        decoratorRequestModel.setIprst(iprst);
        decoratorRequestModel.setAssets(assets);
        decoratorRequestModel.setPositionId(positionId);
        TicketInterceptorInvocation invocation = new TicketInterceptorInvocation();
        invocation.setRequestModel(decoratorRequestModel);
        this.ticketDecoratorInterceptorChain.intercept((Invocation)invocation);
        if (CollectionUtils.isEmpty((Collection)assets)) {
            return null;
        }
        return (TicketAssets)assets.get(0);
    }

    private IP getIp(String ip) {
        IP iprst = this.ipLibrary.find(ip);
        if (null == iprst) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u65e0\u6cd5\u83b7\u53d6\u5230IP\uff1a{} \u7684\u533a\u57df\u4fe1\u606f", (Object)ip);
            }
            iprst = new IP("\u4e2d\u56fd", "\u4e2d\u56fd", "\u4e2d\u56fd");
        }
        return iprst;
    }

    private List<Ticket> getAllTicketsForList() {
        return Lists.newArrayList(this.getAllTicketsForMap().values());
    }

    private Map<BigInteger, Ticket> getAllTicketsForMap() {
        Map hfetchall = this.fetcher.hfetchall(TicketKeyGenerator.getAllTickets(), null, Ticket.class);
        if (MapUtils.isEmpty((Map)hfetchall)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        Set entries = hfetchall.entrySet();
        for (Map.Entry entry : entries) {
            Ticket value = (Ticket)entry.getValue();
            result.put(TypeHelper.castToBigInteger(entry.getKey()), value);
        }
        return result;
    }
}

