/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class TicketStatisticsServiceImpl
implements TicketStatisticsService {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public long getBudgetOfToday(BigInteger ticketId) {
        Long rst = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfDaily(), String.valueOf(ticketId), null, Long.class);
        return null == rst ? 0L : rst;
    }

    public long getBudgetOfTimeline(BigInteger ticketId, int startHour, int endHour) {
        if (endHour < startHour) {
            throw new IllegalArgumentException("endHour must be >= startHour. " + endHour + "<" + startHour);
        }
        BigDecimal rst = new BigDecimal(0);
        for (int i = startHour; i <= endHour; ++i) {
            Long rstForHour = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfHourly((int)i), String.valueOf(ticketId), null, Long.class);
            if (null == rstForHour) continue;
            rst = rst.add(new BigDecimal(rstForHour));
        }
        return rst.longValue();
    }
}

