/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketWeightService;
import com.bxm.adsprod.facade.ticket.TicketWithWeight;
import com.bxm.adsprod.service.commons.configure.AdsProdConfiguration;
import com.bxm.adsprod.service.user.UserStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class TicketWeightServiceImpl
implements TicketWeightService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketWeightServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private UserStatisticsService userStatisticsService;
    private ExecutorService pool;

    public TicketWeightServiceImpl(AdsProdConfiguration adsProdConfiguration) {
        this.pool = new ThreadPoolExecutor(adsProdConfiguration.getWeight().getPoolCoreSize(), adsProdConfiguration.getWeight().getMaxinumCoreSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("ws"));
    }

    @PreDestroy
    public void destroy() {
        this.pool.shutdown();
    }

    public void setWeight(String position, BigInteger ticketId, BigDecimal weight) {
        if (StringUtils.isBlank((String)position)) {
            return;
        }
        if (null == ticketId) {
            return;
        }
        this.updater.hupdate(TicketKeyGenerator.Weight.getWeight((String)position), String.valueOf(ticketId), (Object)weight);
    }

    public BigDecimal getWeight(String position, BigInteger ticketId) {
        if (StringUtils.isBlank((String)position)) {
            return null;
        }
        if (null == ticketId) {
            return null;
        }
        return (BigDecimal)this.fetcher.hfetch(TicketKeyGenerator.Weight.getWeight((String)position), String.valueOf(ticketId), null, BigDecimal.class);
    }

    public TicketCache getBest(List<TicketCache> tickets, final String uid, Ticket last, final String position) {
        ArrayList rst = Lists.newArrayList();
        ArrayList futures = Lists.newArrayList();
        for (final TicketCache ticket : tickets) {
            Future<TicketWithWeight> future = this.pool.submit(new Callable<TicketWithWeight>(){

                @Override
                public TicketWithWeight call() throws Exception {
                    BigInteger ticketId = ticket.getId();
                    BigDecimal weight = TicketWeightServiceImpl.this.getWeight(position, ticketId);
                    TicketWithWeight ticketWithWeight = new TicketWithWeight(null == weight ? new BigDecimal(0) : weight);
                    ticketWithWeight.setTicketId(ticketId);
                    ticketWithWeight.setDomainCode(ticket.getDomainCode());
                    long count = TicketWeightServiceImpl.this.userStatisticsService.countViewOfToday(uid, ticketId);
                    ticketWithWeight.setCount(count);
                    return ticketWithWeight;
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                TicketWithWeight ticketWithWeight = (TicketWithWeight)future.get();
                rst.add(ticketWithWeight);
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("get:", (Throwable)e);
            }
        }
        Collections.sort(rst);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sorted: {}", (Object)rst);
        }
        TicketWithWeight finalTicket = TicketWeightServiceImpl.getNext(rst, last);
        for (TicketCache ticket : tickets) {
            if (!ticket.getId().equals(finalTicket.getTicketId())) continue;
            return ticket;
        }
        return null;
    }

    private static TicketWithWeight getNext(List<TicketWithWeight> tickets, Ticket last) {
        TicketWithWeight firstDifferentWithTag;
        TicketWithWeight next = tickets.get(0);
        if (last == null) {
            return next;
        }
        if (!TicketWeightServiceImpl.existsWithTag(tickets, last.getDomainCode())) {
            return next;
        }
        if (StringUtils.equals((String)last.getDomainCode(), (String)next.getDomainCode()) && null != (firstDifferentWithTag = TicketWeightServiceImpl.getFirstDifferentWithTag(tickets, last.getDomainCode()))) {
            return firstDifferentWithTag;
        }
        return next;
    }

    private static boolean existsWithTag(List<TicketWithWeight> tickets, String domainOfLast) {
        for (TicketWithWeight ticket : tickets) {
            if (!StringUtils.equals((String)ticket.getDomainCode(), (String)domainOfLast)) continue;
            return true;
        }
        return false;
    }

    private static TicketWithWeight getFirstDifferentWithTag(List<TicketWithWeight> tickets, String domainOfLast) {
        for (TicketWithWeight ticket : tickets) {
            if (StringUtils.equals((String)ticket.getDomainCode(), (String)domainOfLast)) continue;
            return ticket;
        }
        return null;
    }
}

