/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.decorator;

import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.service.ticket.decorator.DecoratorRequestModel;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.ip.IP;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TicketAssetsInterceptor
extends AbstractInterceptor {
    protected void doIntercept(Invocation invocation) {
        DecoratorRequestModel requestModel = (DecoratorRequestModel)invocation.getRequestModel();
        IP iprst = requestModel.getIprst();
        String regioncode = iprst.getRegioncode();
        if (StringUtils.isBlank((String)regioncode)) {
            return;
        }
        List<TicketAssets> assets = requestModel.getAssets();
        if (CollectionUtils.isEmpty(assets)) {
            return;
        }
        for (TicketAssets asset : assets) {
            if (null == asset.getVars()) continue;
            if (asset.getVars() == 1) {
                this.fillNameForVars(asset, iprst.getProvince());
                continue;
            }
            if (asset.getVars() != 2) continue;
            this.fillNameForVars(asset, iprst.getCity());
        }
    }

    private void fillNameForVars(TicketAssets asset, String varValue) {
        StringBuilder name = new StringBuilder();
        if (StringUtils.isNotBlank((String)asset.getName())) {
            name.append(asset.getName());
        }
        asset.setName(name.append(varValue).append(asset.getContent()).toString());
    }
}

