/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.decorator;

import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketAssetsService;
import com.bxm.adsprod.facade.ticket.assets.TicketAssetsStatistics;
import com.bxm.adsprod.service.ticket.decorator.DecoratorRequestModel;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketAssetsScoreInterceptor
extends AbstractInterceptor {
    private static final int DEFAULT_CLOSE_THRESHOLD = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketAssetsScoreInterceptor.class);
    @Autowired
    private TicketAssetsService ticketAssetsService;

    protected void doIntercept(Invocation invocation) {
        DecoratorRequestModel requestModel = (DecoratorRequestModel)invocation.getRequestModel();
        List<TicketAssets> assets = requestModel.getAssets();
        if (CollectionUtils.isEmpty(assets)) {
            return;
        }
        TicketAssets best = this.getBest(requestModel.getPositionId(), assets);
        assets.removeIf(next -> !next.getId().equals(best.getId()));
    }

    private TicketAssets getBest(String positionId, List<TicketAssets> assets) {
        if (assets.size() == 1) {
            return assets.get(0);
        }
        ArrayList result = Lists.newArrayList();
        for (TicketAssets asset : assets) {
            Double score;
            block5: {
                if (asset.getClickThreshold() == null) {
                    asset.setClickThreshold(Integer.valueOf(100));
                }
                score = 0.0;
                try {
                    score = this.getScore2(positionId, asset);
                }
                catch (Exception e) {
                    if (!LOGGER.isErrorEnabled()) break block5;
                    LOGGER.error("getScore2: " + asset.getId(), (Throwable)e);
                }
            }
            result.add(TicketAssetsWithScore.of(asset, new BigDecimal(score)));
        }
        Collections.sort(result);
        return ((TicketAssetsWithScore)result.get((int)0)).assets;
    }

    private double getScore2(String positionId, TicketAssets asset) {
        if (!asset.isAvailable()) {
            return 0.0;
        }
        double clickRatio = 0.9;
        double validClickRatio = 0.9;
        int closeThreshold = NumberUtils.toInt((String)TypeHelper.castToString((Object)asset.getClickThreshold()), (int)100);
        BigInteger id = asset.getId();
        TicketAssetsStatistics statistics = this.ticketAssetsService.getOfHours(positionId, id, 2);
        if (statistics.getViews() < (long)closeThreshold) {
            statistics = this.ticketAssetsService.getOfHours(positionId, id, 24);
        }
        if (statistics.getViews() < (long)closeThreshold) {
            statistics = this.ticketAssetsService.getOfHours(positionId, id, -1);
        }
        if (statistics.getViews() >= (long)closeThreshold) {
            clickRatio = this.divide(statistics.getClicks(), statistics.getViews());
            validClickRatio = this.divide(statistics.getValidClicks(), statistics.getClicks());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("\u6700\u7ec8\u6570\u636e-\u5e7f\u544a\u4f4d{},\u7d20\u6750ID{},\u70b9\u51fb{},\u66dd\u5149{},\u70b9\u51fb\u7387{}", new Object[]{positionId, asset.getId(), statistics.getClicks(), statistics.getViews(), clickRatio});
        }
        return clickRatio + validClickRatio * 0.0;
    }

    private double divide(long a, long b) {
        if (b == 0L) {
            return 0.0;
        }
        return new BigDecimal(a).divide(new BigDecimal(b), 7, 4).doubleValue();
    }

    static final class TicketAssetsWithScore
    implements Comparable<TicketAssetsWithScore> {
        TicketAssets assets;
        BigDecimal score;

        TicketAssetsWithScore() {
        }

        private static TicketAssetsWithScore of(TicketAssets assets, BigDecimal score) {
            TicketAssetsWithScore o = new TicketAssetsWithScore();
            o.assets = assets;
            o.score = score;
            return o;
        }

        @Override
        public int compareTo(TicketAssetsWithScore o) {
            return Double.compare(o.score.doubleValue(), this.score.doubleValue());
        }
    }
}

