/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.event.listeners;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.service.ticket.event.BalanceChangedEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BalanceChangedEventListener
implements EventListener<BalanceChangedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BalanceChangedEventListener.class);
    @Autowired
    private TicketService ticketService;

    public void consume(BalanceChangedEvent event) {
        long finalValue = event.getFinalValue();
        if (finalValue > 0L) {
            List allTickets = this.ticketService.getAllTickets();
            for (Ticket ticket : allTickets) {
                boolean isPauseStatus;
                if (null == ticket.getAdvertiser() || !ticket.getAdvertiser().equals(event.getAdvertiser()) || !(isPauseStatus = ticket.getStatus() == 2 && ticket.getPauseReason() == 2)) continue;
                BigInteger ticketId = ticket.getId();
                if (this.ticketService.updateTicketStatus(ticketId, (byte)1, 0)) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6253\u5f00)\u66f4\u65b0\u5b8c\u6210", (Object)ticketId);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6253\u5f00)\u66f4\u65b0\u5931\u8d25!", (Object)ticketId);
            }
        }
    }
}

