/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.event.listeners;

import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.ticket.event.OcpcThresholdEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import java.math.BigInteger;
import org.springframework.stereotype.Component;

@Component
public class OcpcThresholdEventListener
implements EventListener<OcpcThresholdEvent> {
    private final OcpcService ocpcService;

    public OcpcThresholdEventListener(OcpcService ocpcService) {
        this.ocpcService = ocpcService;
    }

    public void consume(OcpcThresholdEvent event) {
        Ticket response = event.getResponse();
        if (null == response) {
            return;
        }
        BigInteger ticketId = response.getId();
        String position = event.getPosition();
        if (event.isClose()) {
            this.ocpcService.addToClosePool(ticketId, position);
        } else {
            this.ocpcService.removeToClosePool(ticketId, position);
        }
    }
}

